#!/usr/bin/env python

import os
import dynamixel
import time
import random


# Liczba układów Dynamixel na magistrali.
nServos = 1

# Odpowiednie ustawienie portu szeregowego.
if os.name == "posix":
    portName = "/dev/ttyUSB0"
else:
    portName = "COM6"
    
# Domyślna prędkość transmisji urządzenia USB2Dynamixel.
baudRate = 1000000

# Podłączenie do portu szeregowego
print "Connecting to serial port", portName, '...',
serial = dynamixel.serial_stream.SerialStream( port=portName, baudrate=baudRate, timeout=1)
print "Connected!"
net = dynamixel.dynamixel_network.DynamixelNetwork( serial )
net.scan( 1, nServos )

# Lista przechowująca układy Dynamixel
myActuators = list()
print myActuators

This will create a list for storing  dynamixel actuators details.

print "Scanning for Dynamixels...",
for dyn in net.get_dynamixels():
    print dyn.id,
    myActuators.append(net[dyn.id])
print "...Done"


# Ustawienie domyślnej prędkości i momentu obrotowego
for actuator in myActuators:
    actuator.moving_speed = 50
    actuator.synchronized = True
    actuator.torque_enable = True
    actuator.torque_limit = 800
    actuator.max_torque = 800

# Losowe przemieszczenie układów serwo i wyświetlenie ich bieżących pozycji
while True:
    for actuator in myActuators:
        actuator.goal_position = random.randrange(450, 600)
    net.synchronize()
    for actuator in myActuators:
        actuator.read_all()
        time.sleep(0.01)

    for actuator in myActuators:
        print actuator.cache[dynamixel.defs.REGISTER['Id']], actuator.cache[dynamixel.defs.REGISTER['CurrentPosition']]

    time.sleep(2)

    

	
	