import bpy



#Ta funkcja narysuje płytę bazową
def Draw_Base_Plate():
    
    
    #Dodanie dwóch sześcianów dla dwóch wcięć płyty bazowej
    
    bpy.ops.mesh.primitive_cube_add(radius=0.05, location=(0.175,0,0.09))
    bpy.ops.mesh.primitive_cube_add(radius=0.05, location=(-0.175,0,0.09))
    
    #############################################################################################
    
    #Dodanie płyty bazowej
    bpy.ops.mesh.primitive_cylinder_add(radius=0.15,depth=0.005, location=(0,0,0.09))
    
    #Dodanie modyfikatora różnicy Boolean na podstawie pierwszego sześcianu
    
    bpy.ops.object.modifier_add(type='BOOLEAN')
    bpy.context.object.modifiers["Boolean"].operation = 'DIFFERENCE'
    bpy.context.object.modifiers["Boolean"].object = bpy.data.objects["Cube"]
    bpy.ops.object.modifier_apply(modifier="Boolean")
    
    
    #############################################################################################

    #Dodanie modyfikatora różnicy Boolean na podstawie drugiego sześcianu
    
    bpy.ops.object.modifier_add(type='BOOLEAN')
    bpy.context.object.modifiers["Boolean"].operation = 'DIFFERENCE'
    bpy.context.object.modifiers["Boolean"].object = bpy.data.objects["Cube.001"]
    bpy.ops.object.modifier_apply(modifier="Boolean")
    
    
    #############################################################################################
    
    #Anulowanie zaznaczenia cylindra i usunięcie sześcianów
    bpy.ops.object.select_pattern(pattern="Cube")
    bpy.ops.object.select_pattern(pattern="Cube.001")
    bpy.data.objects['Cylinder'].select = False
    bpy.ops.object.delete(use_global=False)
    
    
    
#Ta funkcja narysuje silniki i koła
def Draw_Motors_Wheels():
    
    
       
    #Stworzenie pierwszego koła
    
    bpy.ops.mesh.primitive_cylinder_add(radius=0.045,depth=0.01, location=(0,0,0.07))
    #Obrót
    bpy.context.object.rotation_euler[1] = 1.5708
    #Przesunięcie
    bpy.context.object.location[0] = 0.135

    #Stworzenie drugiego koła
    bpy.ops.mesh.primitive_cylinder_add(radius=0.045,depth=0.01, location=(0,0,0.07))
    #Obrót
    bpy.context.object.rotation_euler[1] = 1.5708
    #Przesunięcie
    bpy.context.object.location[0] = -0.135

    #Dodanie silników
    
    bpy.ops.mesh.primitive_cylinder_add(radius=0.018,depth=0.06, location=(0.075,0,0.075))
    bpy.context.object.rotation_euler[1] = 1.5708
    
    bpy.ops.mesh.primitive_cylinder_add(radius=0.018,depth=0.06, location=(-0.075,0,0.075))
    bpy.context.object.rotation_euler[1] = 1.5708
    
   
    #Dodanie wału silnika
    bpy.ops.mesh.primitive_cylinder_add(radius=0.006,depth=0.04, location=(0.12,0,0.075))
    bpy.context.object.rotation_euler[1] = 1.5708
    
    bpy.ops.mesh.primitive_cylinder_add(radius=0.006,depth=0.04, location=(-0.12,0,0.075))
    bpy.context.object.rotation_euler[1] = 1.5708
    
    
    #############################################################################################
    
    #Dodawanie koła kastora
    
    bpy.ops.mesh.primitive_cylinder_add(radius=0.015,depth=0.05, location=(0,0.125,0.065))
    bpy.ops.mesh.primitive_cylinder_add(radius=0.015,depth=0.05, location=(0,-0.125,0.065))
    
    #Dodanie sensora Kinect
    
    bpy.ops.mesh.primitive_cube_add(radius=0.04, location=(0,0,0.26))    
    
#Rysowanie płyty środkowej
def Draw_Middle_Plate():
    bpy.ops.mesh.primitive_cylinder_add(radius=0.15,depth=0.005, location=(0,0,0.22))

#Dodawanie płyty górnej
def Draw_Top_Plate():
    bpy.ops.mesh.primitive_cylinder_add(radius=0.15,depth=0.005, location=(0,0,0.37))

#Dodawanie tulejek wspierających
def Draw_Support_Tubes():
#############################################################################################
    
    #Cylindry
    bpy.ops.mesh.primitive_cylinder_add(radius=0.007,depth=0.30, location=(0.09,0.09,0.23))
    bpy.ops.mesh.primitive_cylinder_add(radius=0.007,depth=0.30, location=(-0.09,0.09,0.23))
    bpy.ops.mesh.primitive_cylinder_add(radius=0.007,depth=0.30, location=(-0.09,-0.09,0.23))
    bpy.ops.mesh.primitive_cylinder_add(radius=0.007,depth=0.30, location=(0.09,-0.09,0.23))

#Eksport do STL   
def Save_to_STL():
    bpy.ops.object.select_all(action='SELECT')
# Należy ustawić ścieżkę filepath na istniejący folder
    bpy.ops.export_mesh.stl(check_existing=True,
        filepath="/home/radoslaw/Desktop/exported.stl",
        filter_glob="*.stl", ascii=False,
        use_mesh_modifiers=True, axis_forward='Y',
        axis_up='Z', global_scale=1.0)

  

#Główny kod

if __name__ == "__main__":
    Draw_Base_Plate()
    Draw_Motors_Wheels()
    Draw_Middle_Plate()
    Draw_Top_Plate()
    Draw_Support_Tubes()
    Save_to_STL()
