#!/usr/bin/env python



import gobject
import sys

#Aby skorzystać z API frameworka gstreamer, należy zaimportować poniższe moduły
import pygst
pygst.require('0.10')
gobject.threads_init()
import gst


#Moduł obsługujący sygnał przerwania klawiatury
import signal


#Procedura obsługi sygnału z klawiatury
def signal_handle(signal, frame):
	print "Wciśnięto Ctrl+C"
	sys.exit(0)



#Implementcja klasy rozpoznawania mowy
class Speech_Recog(object):


	#Inicjalizacja potoku gstreamer i komponentu pocket sphinx
	def __init__(self):
		self.init_gst()

	
	#Ta funkcja zainicjuje potok gstreamer
	def init_gst(self):
	        """Initialize the speech components"""
		#Install
		#sudo apt-get install gstreamer0.10-gconf for gconf

		#Poniższy kod stworzy potok gstreamer wraz z opisem.
		#Ten kod potrzebuje poniższego elementu by rozpocząć rozpoznawanie
        	self.pipeline = gst.parse_launch('gconfaudiosrc ! audioconvert ! audioresample '
                                         + '! vader name=vad auto-threshold=true '
                                         + '! pocketsphinx name=asr ! fakesink')

		#Dostęp do elementu pocket sphinx z potoku gstreamer
        	asr = self.pipeline.get_by_name('asr')
		#Połączenie z funkcją asr_result po ukończeniu konwersji mowy na tekst
        	asr.connect('result', self.asr_result)

		#Użytkownik może wymienić lm oraz dict w celu dokładniejszego wykrywania
#	        asr.set_property('lm', '/home/user/mylanguagemodel.lm')
#        	asr.set_property('dict', '/home/user/mylanguagemodel.dic')

		    #Sprawdzenie, czy wszystkie opcje są dobrze skonfigurowane i rozpoczęcie rozpoznawania
        	asr.set_property('configured', True)
        	self.pipeline.set_state(gst.STATE_PAUSED)


    	def asr_result(self, asr, text, uttid):
		#Wyświetlenie wykrytego tekstu
		print "Detected Text=>    ",text



	#Ta funkcja uruchomi/zatrzyma operację rozpoznawania mowy
	def start_recognition(self):
		

		#Detektor aktywności głosu VADER (Voice Activity DEtectoR) pomaga określić
        #początek i koniec sygnału mowy. Stworzenie obiektu VADER i ustawienie
        #właściwości silent na False. Dzięki temu mowa nie będzie rozpoznawana aż do
        #wciśnięcia klawisza
	        vader = self.pipeline.get_by_name('vad')
        	vader.set_property('silent', False)
		#Oczekiwanie na wciśnięcie klawisza uruchamiającego rozpoznawanie mowy
		raw_input("Press any key to start recognition:>")
		#Rozpoczęcie odtwarzania potoku
		self.pipeline.set_state(gst.STATE_PLAYING)

		#Oczekiwanie na zatrzymanie rozpoznawania
		raw_input("Press any key to stop recognition:>")
	        vader = self.pipeline.get_by_name('vad')
		#Ustawienie właściwości silent obiektu VADER na TRUE
        	vader.set_property('silent', True)
		#Pauza potoku GStreamer
      		self.pipeline.set_state(gst.STATE_PAUSED)


if __name__ == "__main__":

	#Utworzenie obiektu klasy Speech_Recog()
	app_object = Speech_Recog()


	#Przypisanie procedury obsługi przerwania klawiatury

	signal.signal(signal.SIGINT, signal_handle)

	while True:

		#Wywołanie procedury rozpoznawania mowy
		app_object.start_recognition()
