# Wyświetla "Witaj, <imię>!", używając imienia "Ziemianin", jeżeli
# bieżący użytkownik jest anonimowy.

DROP PROCEDURE IF EXISTS greetings;
delimiter $
#@ _FRAG_
CREATE PROCEDURE greetings ()
BEGIN
  # 77 = 16 for username + 60 for hostname + 1 for '@'
  DECLARE user CHAR(77) CHARACTER SET utf8;
  SET user = (SELECT CURRENT_USER());
  IF INSTR(user,'@') > 0 THEN
    SET user = SUBSTRING_INDEX(user,'@',1);
  END IF;
  IF user = '' THEN         # Użytkownik anonimowy
    SET user = 'Ziemianin';
  END IF;
  SELECT CONCAT('Witaj, ',user, '!') AS greeting;
END;
#@ _FRAG_
$
delimiter ;
CALL greetings();
