<?php
#@ _OUTLINE_PART_1_
# pres_quiz.php - Skrypt będący quizem na temat miejsc urodzenia prezydentów USA.

require_once "sampdb_pdo.php";
#@ _OUTLINE_PART_1_

#@ _DISPLAY_FORM_
function display_form ($name, $place, $choices)
{
  printf ("<form method=\"post\" action=\"%s\">\n", script_name ());
  hidden_field ("name", $name);
  hidden_field ("place", $place);
  hidden_field ("choices", implode ("#", $choices));
  printf ("Gdzie urodził się prezydent %s?<br /><br />\n", htmlspecialchars ($name));
  for ($i = 0; $i < 5; $i++)
  {
    radio_button ("response", $choices[$i], $choices[$i], FALSE);
    print ("<br />\n");
  }
  print ("<br />\n");
  submit_button ("submit", "Wyślij");
  print ("</form>\n");
}
#@ _DISPLAY_FORM_

#@ _SETUP_QUIZ_
function present_question ($dbh)
{
  # Wykonanie zapytania. to pick a president and get birthplace
  $stmt = "SELECT CONCAT(first_name, ' ', last_name) AS name,
           CONCAT(city, ', ', state) AS place
           FROM president ORDER BY RAND() LIMIT 1";
  $sth = $dbh->query ($stmt);
  $row = $sth->fetch ();
  $name = $row["name"];
  $place = $row["place"];

  # Przygotowanie zbioru miejsc, które będą wyświetlone jako potencjalne odpowiedzi.
  # Tworzona jest tablica $choices zawierająca pięć miejsc, z których jedno
  # jest prawidłową odpowiedzią na wyświetlone pytanie.
  $stmt = "SELECT DISTINCT CONCAT(city, ', ', state) AS place
           FROM president ORDER BY RAND() LIMIT 5";
  $sth = $dbh->query ($stmt);
  $choices[] = $place;  # Inicjalizacja tablicy wraz z poprawną odpowiedzią.
  while (count ($choices) < 5 && $row = $sth->fetch ())
  {
    if ($row["place"] != $place)
      $choices[] = $row["place"]; # Dodanie innych, niepoprawnych odpowiedzi.
  }
  # Wymieszanie odpowiedzi i wyświetlenie formularza.
  shuffle ($choices);
  display_form ($name, $place, $choices);
}
#@ _SETUP_QUIZ_

# Nie trzeba przeprowadzać weryfikacji parametrów używanych przez
# check_response(). Nie będą przechowywane w bazie danych, po prostu
# sprawdzamy je i prawdopodobnie używamy do utworzenia nowej
# strony internetowej.

#@ _CHECK_RESPONSE_
function check_response ($dbh)
{
  $name = script_param ("name");
  $place = script_param ("place");
  $choices = script_param ("choices");
  $response = script_param ("response");

  # Czy użytkownik podał poprawne miejsce urodzenia prezydenta?

  if ($response == $place)
  {
    print ("Odpowiedź jest poprawna!<br />\n");
    printf ("%s urodził się w %s.<br />\n",
            htmlspecialchars ($name),
            htmlspecialchars ($place));
    print ("Spróbuj odpowiedzieć na kolejne pytanie:<br /><br />\n");
    present_question($dbh);
  }
  else
  {
    printf ("\"%s\" to niepoprawna odpowiedź. Spróbuj ponownie.<br /><br />\n",
            htmlspecialchars ($response));
    $choices = explode ("#", $choices);
    display_form ($name, $place, $choices);
  }
}
#@ _CHECK_RESPONSE_

#@ _OUTLINE_PART_2_
$title = "Quiz na temat miejsc urodzenia prezydentów USA";
html_begin ($title, $title);

$dbh = sampdb_connect ();

#@ _TEST_RESPONSE_
$response = script_param ("response");
if (is_null ($response))   # Skrypt został wywołany po raz pierwszy.
  present_question ($dbh);
else                       # Użytkownik wysłał formularz z odpowiedzią na pytanie.
  check_response ($dbh);
#@ _TEST_RESPONSE_

$dbh = NULL;  # Zamknięcie połączenia.

html_end ();
#@ _OUTLINE_PART_2_
?>
