<?php
# dump_members2.php - Wyświetlenie członków Ligi Historycznej w tabeli HTML
# wraz z łączami dla adresów e-mail.

require_once "sampdb_pdo.php";

$title = "Lista członków Ligi Historycznej";
html_begin ($title, $title);

$dbh = sampdb_connect ();

# Wykonanie zapytania.
$stmt = "SELECT last_name, first_name, suffix, email,"
      . " street, city, state, zip, phone FROM member ORDER BY last_name";
$sth = $dbh->query ($stmt);

print ("<table>\n");          # Początek tabeli.
# Odczyt wyników zapytania, a następnie usunięcie danych z pamięci.
#@ _ROW_PRINT_LOOP_
while ($row = $sth->fetch (PDO::FETCH_NUM))
{
  print ("<tr>\n");           # Początek wiersza tabeli.
  for ($i = 0; $i < $sth->columnCount (); $i++)
  {
    print ("<td>");
    # Cytowanie wszystkich znaków specjalnych i wygenerowanie komórki tabeli.
    # Adres e-mail znajduje się w kolumnie 4 (indeks 3) zbioru wynikowego.
    if ($i == 3 && $row[$i] != "")
    {
      printf ("<a href=\"mailto:%s\">%s</a>",
              $row[$i],
              htmlspecialchars ($row[$i]));
    }
    else
    {
      print (htmlspecialchars ($row[$i]));
    }
    print ("</td>\n");
  }
  print ("</tr>\n");          # Koniec wiersza tabeli.
}
#@ _ROW_PRINT_LOOP_
print ("</table>\n");         # Koniec tabeli.

$dbh = NULL;  # Zamknięcie połączenia.

html_end ();
?>
