#!/usr/bin/perl
# transaction.pl - Skrypt pokazuje sposób działania mechanizmu abstrakcji transakcji DBI.

use strict;
use warnings;
use DBI;

# Przetworzenie parametrów z wiersza poleceń, o ile zostały podane.

use Getopt::Long;
$Getopt::Long::ignorecase = 0; # Wielkość liter w opcjach ma znaczenie.
$Getopt::Long::bundling = 1;   # -uname = -u name, a nie -u -n -a -m -e

# Parametry domyślne, wszystkie początkowo niezdefiniowane.
my ($host_name, $password, $port_num, $socket_name, $user_name);

GetOptions (
  # =i oznacza, że po opcji trzeba podać wartość w postaci liczby całkowitej.
  # =s oznacza, że po opcji trzeba podać wartość w postaci ciągu tekstowego.
  "host|h=s"      => \$host_name,
  "password|p=s"  => \$password,
  "port|P=i"      => \$port_num,
  "socket|S=s"    => \$socket_name,
  "user|u=s"      => \$user_name
) or exit (1);

# Utworzenie źródła danych.
my $dsn = "DBI:mysql:sampdb";
$dsn .= ";host=$host_name" if $host_name;
$dsn .= ";port=$port_num" if $port_num;
$dsn .= ";mysql_socket=$socket_name" if $socket_name;
$dsn .= ";mysql_read_default_group=client";

# Nawiązanie połączenia z serwerem.
my %conn_attrs = (RaiseError => 1, PrintError => 0, AutoCommit => 1);
my $dbh = DBI->connect ($dsn, $user_name, $password, \%conn_attrs);

#@ _TRANSACTION_
my $orig_re = $dbh->{RaiseError}; # Zachowanie stanu atrybutów obsługi błędów.
my $orig_pe = $dbh->{PrintError};
my $orig_ac = $dbh->{AutoCommit}; # Zachowanie stanu trybu automatycznego zatwierdzania.

$dbh->{RaiseError} = 1;           # Błąd powinien zgłosić wyjątek.
$dbh->{PrintError} = 0;           # Zawieszenie wyświetlania komunikatów błędów.
$dbh->{AutoCommit} = 0;           # Wyłączenie automatycznego zatwierdzania zapytań.

eval
{
  # Wykonanie zapytań, które zaliczają się do transakcji.
  my $sth = $dbh->prepare (qq{
              UPDATE score SET score = ?
              WHERE event_id = ? AND student_id = ?
            });
  $sth->execute (13, 5, 8);
  $sth->execute (18, 5, 9);
  $dbh->commit();                 # Zatwierdzenie transakcji.
};
if ($@)                           # Czy transakcja zakończyła się niepowodzeniem?
{
  print "Wystąpił błąd w trakcie transakcji: $@\n";
  # Wycofanie transakcji, użycie eval do przechwycenia niepowodzenia wycofania.
  eval { $dbh->rollback (); }
}

$dbh->{AutoCommit} = $orig_ac;    # Przywrócenie stanu trybu automatycznego zatwierdzania zapytań.
$dbh->{RaiseError} = $orig_re;    # Przywrócenie stanu atrybutów obsługi błędów.
$dbh->{PrintError} = $orig_pe;
#@ _TRANSACTION_

$dbh->disconnect ();
