<?php
#@ _OUTLINE_PART_1_
# edit_member.php - Edycja przez przeglądarkę internetową informacji o członkach Ligi Historycznej.

require_once "sampdb_pdo.php";

# Zdefiniowanie stałych określających podejmowane działania.
define ("SHOW_INITIAL_PAGE", 0);
define ("DISPLAY_ENTRY", 1);
define ("UPDATE_ENTRY", 2);
#@ _OUTLINE_PART_1_

# Wyświetlenie formularza pozwalającego na podanie identyfikatora członka Ligi i jego hasła.

#@ _SOLICIT_MEMBER_ID_
function display_login_page ()
{
  printf ("<form method=\"post\" action=\"%s?action=%d\">\n",
          script_name (),
          DISPLAY_ENTRY);
  print ("Podaj identyfikator członka Ligi i hasło,\n");
  print ("a następnie kliknij przycisk Wyślij.\n<br /><br />\n");
  print ("<table>\n");
  print ("<tr>");
  print ("<td>Identyfikator członka Ligi</td><td>");
  text_field ("member_id", "", 10);
  print ("</td></tr>");
  print ("<tr>");
  print ("<td>Hasło</td><td>");
  password_field ("password", "", 10);
  print ("</td></tr>");
  print ("</table>\n");
  submit_button ("button", "Wyślij");
  print "</form>\n";
}
#@ _SOLICIT_MEMBER_ID_

# Wyświetlenie kolumny z rekordu informacji o członku Ligi. $label to widoczna
# etykieta wyświetlana użytkownikowi. $row to tablica zawierająca rekord
# członka Ligi. $col_name to nazwa kolumny w rekordzie. Zmienna $editable
# powinna mieć wartość true, jeżeli użytkownik ma uprawnienia do zmiany wartości kolumny.
# (W przeciwnym razie wartość jest wyświetlana jako nieedytowalna). Zmienna $editable
# jest opcjonalna. W przypadku jej braku przyjmuje się, że ma domyślnie wartość true.
# Nazwy pól są tworzone za pomocą formatu row[col_name], po wysłaniu formularza,
# dostęp do wartości jest możliwy przez tablicę $row zamiast wiele
# oddzielnych zmiennych.

#@ _DISPLAY_COLUMN_
function display_column ($label, $row, $col_name, $editable = TRUE)
{
  print ("<tr>\n");
  print ("<td>" . htmlspecialchars ($label) . "</td>\n");
  print ("<td>");
  if ($editable)  # Wyświetlenie w postaci pola, którego zawartość można edytować.
    text_field ("row[$col_name]", $row[$col_name], 80);
  else            # Wyświetlenie w postaci tekstu tylko do odczytu.
    print (htmlspecialchars ($row[$col_name]));
  print ("</td>\n");
  print ("</tr>\n");
}
#@ _DISPLAY_COLUMN_

#@ _CHECK_PASS_
function check_pass ($dbh, $id, $pass)
{
  $stmt = "SELECT password FROM member_pass WHERE member_id = ?";
  $sth = $dbh->prepare ($stmt);
  $sth->execute (array ($id));
  # Wartość TRUE w przypadku znalezienia i dopasowania hasła.
  return (($row = $sth->fetch ()) && $row["password"] == $pass);
}
#@ _CHECK_PASS_

# Ustalenie, czy klient podał prawidłowe hasło.
# Jeżeli tak, będzie mógł edytować rekord.

#@ _DISPLAY_ENTRY_
function display_entry ($dbh)
{
  # Pobranie parametrów skryptu; usunięcie znaków odstępu z identyfikatora, ale nie
  # z hasła, ponieważ hasło musi być idealnie dopasowane.

  $member_id = trim (script_param ("member_id"));
  $password = script_param ("password");

  if (empty ($member_id))
    die ("Nie podano identyfikatora członka Ligi.\n");
  if (!ctype_digit ($member_id))                # Identyfikator zdarzenia musi być liczbą całkowitą.
    die ("Nieprawidłowy identyfikator (musi być liczbą całkowitą).\n");
  if (empty ($password))
    die ("Nie podano hasła\n");
  if (check_pass ($dbh, $member_id, $password)) # Zwykły członek Ligi.
    $admin = FALSE;
  else if (check_pass ($dbh, 0, $password))     # Administrator.
    $admin = TRUE;
  else
    die ("Nieprawidłowe hasło.\n");

  $stmt = "SELECT
             last_name, first_name, suffix, email, street, city,
             state, zip, phone, interests, member_id, expiration
           FROM member WHERE member_id = ?
           ORDER BY last_name";
  $sth = $dbh->prepare ($stmt);
  $sth->execute (array ($member_id));

  if (!($row = $sth->fetch ()))
    die ("Nie znaleziono członka Ligi o identyfikatorze $member_id.\n");

  printf ("<form method=\"post\" action=\"%s?action=%d\">\n",
          script_name (),
          UPDATE_ENTRY);

  # Dodanie identyfikatora i hasła członka Ligi jako ukrytych wartości, aby w trakcie kolejnego wywołania
  # skryptu było wiadomo, który rekord odpowiada tym wartościom. Dzięki temu użytkownik
  # nie będzie musiał ponownie podawać danych uwierzytelniających.

  hidden_field ("member_id", $member_id);
  hidden_field ("password", $password);

  # Sformatowanie wyników zapytania.

  print ("<table>\n");

  # Wyświetlenie identyfikatora członka Ligi w postaci statycznego tekstu.

  display_column ("Identyfikator członka Ligi", $row, "member_id", FALSE);

  # Zmienna $admin ma wartość true, jeśli użytkownik podał hasło administracyjne.
  # W przeciwnym razie wartością zmiennej jest false. Administrator ma możliwość edycji
  # daty wygaśnięcia członkostwa, zwykły użytkownik nie ma tej możliwości.

  display_column ("Data wygaśnięcia członkostwa", $row, "expiration", $admin);

  # Display other values as editable text

  display_column ("Nazwisko", $row, "last_name");
  display_column ("Imię", $row, "first_name");
  display_column ("Przyrostek", $row, "suffix");
  display_column ("E-mail", $row, "email");
  display_column ("Ulica", $row, "street");
  display_column ("Miejscowość", $row, "city");
  display_column ("Województwo", $row, "state");
  display_column ("Kod pocztowy", $row, "zip");
  display_column ("Telefon", $row, "phone");
  display_column ("Zainteresowania", $row, "interests");

  print ("</table>\n");

  submit_button ("button", "Wyślij");
  print "</form>\n";

}
#@ _DISPLAY_ENTRY_

#@ _UPDATE_ENTRY_
function update_entry ($dbh)
{
  # Pobranie parametrów skryptu; usunięcie znaków odstępu z identyfikatora,
  # ale nie z hasła (ponieważ hasło musi być idealnie dopasowane) oraz
  # nie z rekordu (ponieważ jest tablicą).

  $member_id = trim (script_param ("member_id"));
  $password = script_param ("password");
  $row = script_param ("row");

  if (empty ($member_id))
    die ("Nie podano identyfikatora członka Ligi.\n");
  if (!ctype_digit ($member_id))            # Identyfikator zdarzenia musi być liczbą całkowitą.
    die ("Nieprawidłowy identyfikator (musi być liczbą całkowitą).\n");
  if (!check_pass ($dbh, $member_id, $password)
      && !check_pass ($dbh, 0, $password))
    die ("Nieprawidłowe hasło.\n");

  # Przeanalizowanie metadanych tabeli member w celu ustalenia, czy
  # kolumny akceptują wartość NULL. (Trzeba się upewnić, że informacje
  # o obsłudze wartości NULL są zapisane wielkimi literami).

  $stmt = "SELECT COLUMN_NAME, UPPER(IS_NULLABLE)
           FROM INFORMATION_SCHEMA.COLUMNS
           WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ?";
  $sth = $dbh->prepare ($stmt);
  $sth->execute (array ("sampdb", "member"));
  $nullable = array ();
  while ($info = $sth->fetch ())
    $nullable[$info[0]] = ($info[1] == "YES");

  # Iteracja przez wszystkie pola formularza, wartości są używane
  # do przygotowania zapytania UPDATE zawierającego miejsca zarezerwowane,
  # do których wstawiane są wartości pochodzące z tablicy.

  $stmt = "UPDATE member ";
  $delim = "SET";
  $params = array ();
  foreach ($row as $col_name => $val)
  {
    $stmt .= "$delim $col_name=?";
    $delim = ",";
    # Jeżeli w formularzu nie podano wartości, należy użyć wartości NULL
    # odpowiedniej kolumny, o ile obsługuje ona wartości NULL. To forma ochrony
    # przed umieszczeniem pustego ciągu tekstowego w kolumnie daty wygaśnięcia członkostwa,
    # gdy powinna mieć wartość na przykład NULL.
    $val = trim ($val);
    if (empty ($val))
    {
      if ($nullable[$col_name])
        $params[] = NULL; # Wstawienie wartości NULL.
      else
        $params[] = "";   # Wstawienie pustego ciągu tekstowego.
    }
    else
      $params[] = $val;
  }
  $stmt .= " WHERE member_id = ?";
  $params[] = $member_id;

  $sth = $dbh->prepare ($stmt);
  $sth->execute ($params);
  printf ("<br /><a href=\"%s\">Edycja rekordu innego członka Ligi</a>\n",
          script_name ());
}
#@ _UPDATE_ENTRY_

#@ _OUTLINE_PART_2_
$title = "Liga Historyczna -- formularz edycji informacji o członku Ligi";
html_begin ($title, $title);

$dbh = sampdb_connect ();

# Ustalenie akcji, która powinna zostać podjęta (domyślnie to
# wyświetlenie strony początkowej, jeśli nie zostanie podana żadna akcja).

$action = script_param ("action");
if (is_null ($action))
  $action = SHOW_INITIAL_PAGE;

switch ($action)
{
case SHOW_INITIAL_PAGE:   # Wyświetlenie strony początkowej.
  display_login_page ();
  break;
case DISPLAY_ENTRY:       # Wyświetlenie formularza edycji.
  display_entry ($dbh);
  break;
case UPDATE_ENTRY:        # Uaktualnienie informacji w bazie danych.
  update_entry ($dbh);
  break;
default:
  die ("Nieznany kod ($action)\n");
}

$dbh = NULL;  # Zamknięcie połączenia.

html_end ();
#@ _OUTLINE_PART_2_
?>
