/* #@ _INSERT_RECORDS_ */
static void
insert_rows (MYSQL_STMT *stmt)
{
char          *stmt_str = "INSERT INTO t (i,f,c,dt) VALUES(?,?,?,?)";
MYSQL_BIND    param[4];
int           my_int;
float         my_float;
char          my_str[26]; /* Funkcja ctime() zwraca ciąg tekstowy o długości 26 znaków. */
MYSQL_TIME    my_datetime;
unsigned long my_str_length;
time_t        clock;
struct tm     *cur_time;
int           i;

  printf ("Wstawianie rekordów...\n");

  if (mysql_stmt_prepare (stmt, stmt_str, strlen (stmt_str)) != 0)
  {
    print_stmt_error (stmt, "Nie można było przygotować zapytania INSERT.");
    return;
  }

  /*
   * Wyzerowanie struktur parametrów, a następnie przeprowadzenie inicjalizacji
   * wszystkich parametrów, które są stałe i nie zmieniają każdego rekordu.
   */

  memset ((void *) param, 0, sizeof (param));

  /* Konfiguracja parametru INT. */

  param[0].buffer_type = MYSQL_TYPE_LONG;
  param[0].buffer = (void *) &my_int;
  param[0].is_unsigned = 0;
  param[0].is_null = 0;
  /* buffer_length, wielkości nie trzeba definiować. */

  /* Konfiguracja parametru FLOAT. */

  param[1].buffer_type = MYSQL_TYPE_FLOAT;
  param[1].buffer = (void *) &my_float;
  param[1].is_null = 0;
  /* is_unsigned, buffer_length, wielkości nie trzeba definiować. */

  /* Konfiguracja parametru CHAR. */

  param[2].buffer_type = MYSQL_TYPE_STRING;
  param[2].buffer = (void *) my_str;
  param[2].buffer_length = sizeof (my_str);
  param[2].is_null = 0;
  /* is_unsigned wielkości nie trzeba definiować, wielkość będzie ustawiona później. */

  /* Konfiguracja parametru DATETIME. */

  param[3].buffer_type = MYSQL_TYPE_DATETIME;
  param[3].buffer = (void *) &my_datetime;
  param[3].is_null = 0;
  /* is_unsigned, buffer_length, wielkości nie trzeba definiować. */

  if (mysql_stmt_bind_param (stmt, param) != 0)
  {
    print_stmt_error (stmt, "Nie można dołączyć parametrów zapytania INSERT.");
    return;
  }

  for (i = 1; i <= 5; i++)
  {
    printf ("Wstawienie rekordu %d...\n", i);

    (void) time (&clock); /* Pobranie bieżącej godziny. */
    
    /* Konfiguracja zmiennych używanych dla każdego parametru. */
    
    /* param[0]: ustawienie wartości my_int. */

    my_int = i;

    /* param[1]: ustawienie wartości my_float. */
    my_float = (float) i;

    /* param[2]: przypisanie my_str wartości ciągu tekstowego funkcji current ctime() */
    /* oraz ustawienie długości jako wartości zmiennej wskazującej długość my_str. */
    (void) strcpy (my_str, ctime (&clock));
    my_str[24] = '\0';  /* Usunięcie znaku nowego wiersza na końcu. */
    my_str_length = strlen (my_str);
    param[2].length = &my_str_length;

    /* param[3]: przypisanie my_datetime bieżącej daty i godziny. */
    cur_time = localtime (&clock);
    my_datetime.year = cur_time->tm_year + 1900;
    my_datetime.month = cur_time->tm_mon + 1;
    my_datetime.day = cur_time->tm_mday;
    my_datetime.hour = cur_time->tm_hour;
    my_datetime.minute = cur_time->tm_min;
    my_datetime.second = cur_time->tm_sec;
    my_datetime.second_part = 0;
    my_datetime.neg = 0;

    if (mysql_stmt_execute (stmt) != 0)
    {
      print_stmt_error (stmt, "Nie można wykonać zapytania.");
      return;
    }

    sleep (1);  /* Krótka przerwa (aby umożliwić zmianę godziny). */
  }
}
/* #@ _INSERT_RECORDS_ */


/* #@ _SELECT_RECORDS_ */
static void
select_rows (MYSQL_STMT *stmt)
{
char          *stmt_str = "SELECT i, f, c, dt FROM t";
MYSQL_BIND    param[4];
int           my_int;
float         my_float;
char          my_str[24];
unsigned long my_str_length;
MYSQL_TIME    my_datetime;
my_bool       is_null[4];

  printf ("Pobieranie rekordów...\n");

  if (mysql_stmt_prepare (stmt, stmt_str, strlen (stmt_str)) != 0)
  {
    print_stmt_error (stmt, "Nie można było przygotować zapytania SELECT.");
    return;
  }

  if (mysql_stmt_field_count (stmt) != 4)
  {
    print_stmt_error (stmt, "Nieoczekiwana liczba kolumn w zapytaniu SELECT.");
    return;
  }

  /*
   * Inicjalizacja struktur kolumn wyniku.
   */

  memset ((void *) param, 0, sizeof (param)); /* Wyzerowanie struktur. */

  /* Konfiguracja parametru INT. */

  param[0].buffer_type = MYSQL_TYPE_LONG;
  param[0].buffer = (void *) &my_int;
  param[0].is_unsigned = 0;
  param[0].is_null = &is_null[0];
  /* buffer_length, wielkości nie trzeba definiować. */

  /* Konfiguracja parametru FLOAT. */

  param[1].buffer_type = MYSQL_TYPE_FLOAT;
  param[1].buffer = (void *) &my_float;
  param[1].is_null = &is_null[1];
  /* is_unsigned, buffer_length, wielkości nie trzeba definiować. */

  /* Konfiguracja parametru CHAR. */

  param[2].buffer_type = MYSQL_TYPE_STRING;
  param[2].buffer = (void *) my_str;
  param[2].buffer_length = sizeof (my_str);
  param[2].length = &my_str_length;
  param[2].is_null = &is_null[2];
  /* is_unsigned wielkości nie trzeba definiować. */

  /* Konfiguracja parametru DATETIME. */

  param[3].buffer_type = MYSQL_TYPE_DATETIME;
  param[3].buffer = (void *) &my_datetime;
  param[3].is_null = &is_null[3];
  /* is_unsigned, buffer_length, wielkości nie trzeba definiować. */

  if (mysql_stmt_bind_result (stmt, param) != 0)
  {
    print_stmt_error (stmt, "Nie można dołączyć parametrów zapytania SELECT.");
    return;
  }

  if (mysql_stmt_execute (stmt) != 0)
  {
    print_stmt_error (stmt, "Nie można było wykonać zapytania SELECT.");
    return;
  }

  /*
   * Pobranie wyniku i umieszczenie w pamięci klienta; wprawdzie to jest opcjonalne,
   * ale pozwala na wywołanie funkcji mysql_stmt_num_rows() w celu ustalenia liczby
   * rekordów znajdujących się w zbiorze wynikowym.
   */

  if (mysql_stmt_store_result (stmt) != 0)
  {
    print_stmt_error (stmt, "Nie można było buforować zbioru wynikowego.");
    return;
  }
  else
  {
    /* Wywołanie funkcji mysql_stmt_store_result() pozwala na zliczenie rekordów. */
    printf ("Liczba pobranych rekordów: %lu\n",
            (unsigned long) mysql_stmt_num_rows (stmt));
  }

  while (mysql_stmt_fetch (stmt) == 0)  /* Pobranie każdego rekordu. */
  {
    /* Wyświetlenie wartości rekordu. */
    printf ("%d  ", my_int);
    printf ("%.2f  ", my_float);
    printf ("%*.*s  ", (int) my_str_length, (int) my_str_length, my_str);
    printf ("%04d-%02d-%02d %02d:%02d:%02d\n",
            my_datetime.year,
            my_datetime.month,
            my_datetime.day,
            my_datetime.hour,
            my_datetime.minute,
            my_datetime.second);
  }

  mysql_stmt_free_result (stmt);      /* Usunięcie zbioru wynikowego z pamięci. */
}
/* #@ _SELECT_RECORDS_ */

/* #@ _PROCESS_PREPARED_STATEMENTS_ */
void
process_prepared_statements (MYSQL *conn)
{
MYSQL_STMT *stmt;
char       *use_stmt = "USE sampdb";
char       *drop_stmt = "DROP TABLE IF EXISTS t";
char       *create_stmt =
  "CREATE TABLE t (i INT, f FLOAT, c CHAR(24), dt DATETIME)";

  /* Wybór bazy danych i utworzenie tabeli testowej. */

  if (mysql_query (conn, use_stmt) != 0
    || mysql_query (conn, drop_stmt) != 0
    || mysql_query (conn, create_stmt) != 0)
  {
    print_error (conn, "Nie można było skonfigurować tabeli testowej.");
    return;
  }

  stmt = mysql_stmt_init (conn);  /* Alokacja uchwytu zapytania. */
  if (stmt == NULL)
  {
    print_error (conn, "Nie można było zainicjalizować uchwytu zapytania.");
    return;
  }

  /* Wstawienie i pobranie pewnych rekordów. */
  insert_rows (stmt);
  select_rows (stmt);

  mysql_stmt_close (stmt);       /* Usunięcie z pamięci uchwytu zapytania. */
}
/* #@ _PROCESS_PREPARED_STATEMENTS_ */
