#!/usr/bin/perl
# url.pl - Skrypt pokazuje jak dodawać parametry do adresów URL.

use strict;
use warnings;
use CGI qw(:standard escapeHTML escape);

my $url;

# URL - wersja bez użycia funkcji kodujących.

#@ _MAKE_URL_1_
$url = url ();          # Pobranie adresu URL skryptu.
$url .= "?size=large";  # Dodanie pierwszego parametru.
$url .= ";color=blue";  # Dodanie drugiego parametru.
#@ _MAKE_URL_1_
#@ _PRINT_URL_1_
print a ({-href => $url}, "Kliknij mnie!");
#@ _PRINT_URL_1_
print "\n";

# URL - wersja z funkcjami kodującymi (wartości parametrów i etykieta są
# przechowywane w zmiennych, aby podkreślić, że można nie znać zawartości
# parametrów i etykiety podczas tworzenia adresu URL).

my $size = "large";
my $color = "blue";
my $label = "Kliknij mnie!";
#@ _MAKE_URL_2_
$url = url ();
$url .= "?size=" . escape ($size);
$url .= ";color=" . escape ($color);
#@ _MAKE_URL_2_
#@ _PRINT_URL_2_
print a ({-href => $url}, escapeHTML ($label));
#@ _PRINT_URL_2_
print "\n";

# URL - wersja z funkcjami kodującymi, metoda 2.

#@ _MAKE_URL_3_
$url = sprintf ("%s?size=%s;color=%s",
                url (), escape ($size), escape ($color));
#@ _MAKE_URL_3_
#@ _PRINT_URL_3_
print a ({-href => $url}, escapeHTML ($label));
#@ _PRINT_URL_3_
print "\n";
