#!/usr/bin/perl
# score_browse.pl - Skrypt pozwalający na przeglądanie ocen uczniów.

use strict;
use warnings;
use DBI;
use CGI qw(:standard escapeHTML escape);

use Cwd;
# Plik opcji, który w systemie UNIX powinien zawierać parametry połączenia.
my $option_file = "/usr/local/apache/conf/sampdb.cnf";
my $option_drive_root;
# Nadpisanie położenia pliku w przypadku systemu Windows.
if ($^O =~ /^MSWin/i || $^O =~ /^dos/)
{
  $option_drive_root = "C:/";
  $option_file = "/Apache/conf/sampdb.cnf";
}

# Przygotowanie źródła danych i nawiązanie połączenia z serwerem (w systemie Windows trzeba
# najpierw zachować nazwę bieżącego katalogu roboczego, przejść do dysku zawierającego plik
# opcji, nawiązać połączenie, a następnie powrócić do zapisanego katalogu bieżącego).
my $orig_dir;
if (defined ($option_drive_root))
{
  $orig_dir = cwd ();
  chdir ($option_drive_root)
    or die "Nie można przejść do dysku $option_drive_root: $!\n";
}
my $dsn = "DBI:mysql:sampdb;mysql_read_default_file=$option_file";
my %conn_attrs = (RaiseError => 1, PrintError => 0, AutoCommit => 1);
my $dbh = DBI->connect ($dsn, undef, undef, \%conn_attrs);
if (defined ($option_drive_root))
{
  chdir ($orig_dir)
    or die "Nie można przejść do katalogu $orig_dir: $!\n";
}

#@ _MAIN_BODY_
# Wygenerowanie początkowej części strony internetowej.
my $title = "Przeglądarka ocen uczniów";
print header ();
print start_html (-title => $title, -bgcolor => "white");
print h1 ($title);

# Parametr wskazujący zdarzenie, dla którego mają zostać wyświetlone oceny.
my $event_id = param ("event_id");

# Jeżeli zmienna $event_id nie ma wartości, wtedy zostanie wyświetlona lista zdarzeń.
# W przeciwnym razie wyświetlane są oceny dla wskazanego zdarzenia.
if (!defined ($event_id))
{
  display_events ($dbh)
}
else
{
  display_scores ($dbh, $event_id);
}

print end_html ();
#@ _MAIN_BODY_

$dbh->disconnect ();

#@ _DISPLAY_EVENTS_
sub display_events
{
my $dbh = shift;
my @rows;
my @cells;

  print p ("Wybierz zdarzenie klikając jego numer:");

  # Pobranie listy zdarzeń.
  my $sth = $dbh->prepare (qq{
              SELECT event_id, date, category
              FROM grade_event
              ORDER BY event_id
            });
  $sth->execute ();

  # Użycie nazw kolumn tabeli jako nagłówków w tabeli HTML.
  for (my $i = 0; $i < $sth->{NUM_OF_FIELDS}; $i++)
  {
    push (@cells, th (escapeHTML ($sth->{NAME}->[$i])));
  }
  push (@rows, Tr (@cells));

  # Wyświetlenie informacji o każdym zdarzeniu jako oddzielnego wiersza tabeli HTML.
  while (my ($event_id, $date, $category) = $sth->fetchrow_array ())
  {
    @cells = ();
    # Wyświetlenie identyfikatora zdarzenia jako łącza, którego kliknięcie powoduje
    # ponowne uruchomienie skryptu, i wyświetlenie ocen wskazanego zdarzenia.
    my $url = sprintf ("%s?event_id=%d", url (), $event_id);
    my $link = a ({-href => $url}, escapeHTML ($event_id));
    push (@cells, td ($link));
    # Wyświetlenie daty i kategorii zdarzenia.
    push (@cells, td (escapeHTML ($date)));
    push (@cells, td (escapeHTML ($category)));
    push (@rows, Tr (@cells));
  }

  # Wyświetlenie tabeli wraz z obramowaniem.
  print table ({-border => "1"}, @rows);
}
#@ _DISPLAY_EVENTS_

#@ _DISPLAY_SCORES_
sub display_scores
{
my ($dbh, $event_id) = @_;
my @rows;
my @cells;

  # Wygenerowanie łącza do skryptu niezawierającego parametru
  # event_id. Jeżeli użytkownik kliknie to łącze, skrypt wyświetli
  # listę zdarzeń.

  print p (a ({-href => url ()}, "Pokaż listę zdarzeń"));

  # Pobranie wyników uzyskanych we wskazanym zdarzeniu.
  my $sth = $dbh->prepare (qq{
              SELECT
                student.name,
                grade_event.date,
                score.score,
                grade_event.category
              FROM
                student INNER JOIN score INNER JOIN grade_event
              ON
                student.student_id = score.student_id
                AND score.event_id = grade_event.event_id
              WHERE
                grade_event.event_id = ?
              ORDER BY
                grade_event.date ASC,
                grade_event.category ASC,
                score.score DESC
  });
  $sth->execute ($event_id);  # Umieszczenie identyfikatora zdarzenia w miejscu zarezerwowanym w zapytaniu.

  print p (strong ("Wyniki uzyskane w zdarzeniu $event_id"));

  # Użycie nazw kolumn jako nagłówków w tabeli HTML.
  for (my $i = 0; $i < $sth->{NUM_OF_FIELDS}; $i++)
  {
    push (@cells, th (escapeHTML ($sth->{NAME}->[$i])));
  }
  push (@rows, Tr (@cells));

  while (my @ary = $sth->fetchrow_array ())
  {
    @cells = ();
    foreach my $val (@ary)
    {
      # Wyświetlenie niepustych wartości, w przeciwnym razie wyświetlana jest spacja niełamiąca.
      if (defined ($val) && $val ne "")
      {
        $val = escapeHTML ($val);
      }
      else
      {
        $val = "&nbsp;";
      }
      push (@cells, td ($val));
    }
    push (@rows, Tr (@cells));
  }

  # Wyświetlenie tabeli wraz z obramowaniem.
  print table ({-border => "1"}, @rows);
}
#@ _DISPLAY_SCORES_
