import java.awt.Color;

/**
 * Wielokąt reprezentujący niewielkiego ryjącego ssaka.
 */
public class Mole extends BlinkingPolygon {

    public static final Color BROWN = new Color(153, 102, 0);

    private boolean alive;

    /**
     * Tworzy kreta w podanym miejscu.
     * 
     * @param x współrzędna X 
     * @param y współrzędna Y
     */
    public Mole(int x, int y) {
        super(10, 30, BROWN);
        translate(x, y);
        alive = true;
    }

    @Override
    public void step() {
        // włączaj i wyłączaj w przypadkowych chwilach
        if (alive && Math.random() < 0.5) {
            super.step();
        }
    }

    /**
     * Aktualizuje stan kreta, gdy zostanie on kliknięty.
     */
    public void whack() {
        // ignoruj uderzenie, gdy niewidoczny
        if (visible) {
            color = Color.LIGHT_GRAY;
            alive = false;
        }
    }

}
