import java.awt.Color;
import java.awt.Graphics;

/**
 * Wielokąt, który cyklicznie zmienia kolory i miga.
 */
public class BlinkingPolygon extends RegularPolygon {

    protected boolean visible;
    protected int count;

    /**
     * Konstruuje migający wielokąt.
     * 
     * @param nsides liczba boków
     * @param radius odleglość wierzchołka od środka
     * @param color początkowy kolor wypełnienia
     */
    public BlinkingPolygon(int nsides, int radius, Color color) {
        super(nsides, radius, color);
        visible = true;
        count = 0;
    }

    @Override
    public void draw(Graphics g) {
        if (visible) {
            super.draw(g);
        }
    }

    @Override
    public void step() {
        // przełącz widoczność po każdych 10 krokach
        count++;
        if (count == 10) {
            visible = !visible;
            count = 0;
        }
    }

}
