import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.Timer;

/**
 * Przykładowa gra z duszkiem poruszającym się po ekranie.
 */
public class VideoGame implements ActionListener {

    private Drawing drawing;
    private Toolkit toolkit;

    /**
     * Konfiguruje rysunek i ramkę okna.
     */
    public VideoGame() {
        Sprite sprite = new Sprite("face-smile.png", 50, 50);
        drawing = new Drawing(800, 600);
        drawing.add(sprite);
        drawing.addKeyListener(sprite);
        drawing.setFocusable(true);
        JFrame frame = new JFrame("Gra wideo");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.add(drawing);
        frame.pack();
        frame.setVisible(true);
        toolkit = frame.getToolkit();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        drawing.step();
        toolkit.sync();
    }

    /**
     * Tworzy i uruchamia timer.
     *
     * @param args argumenty wiersza poleceń
     */
    public static void main(String[] args) {
        VideoGame game = new VideoGame();
        Timer timer = new Timer(25, game);
        timer.start();
    }

}
