import java.awt.Color;
import java.awt.Toolkit;
import javax.swing.JFrame;

/**
 * Przykładowa symulacja obiektów animowanych.
 */
public class Sim2 {

    /**
     * Program testowy rysujący kilka wielokątów.
     * 
     * @param args argumenty wiersza poleceń
     */
    public static void main(String[] args) {

        // utwórz kilka wielokątów foremnych
        BlinkingPolygon bp = new BlinkingPolygon(3, 20, Color.BLUE);
        MovingPolygon mp = new MovingPolygon(8, 30);
        RotatingPolygon rp = new RotatingPolygon(5, 40);

        // przenieś je w różne miejsca ekranu
        bp.translate(50, 50);
        mp.translate(100, 100);
        rp.translate(200, 200);

        // utwórz rysunek, dodaj wielokąty
        Drawing drawing = new Drawing(800, 600);
        drawing.add(bp);
        drawing.add(mp);
        drawing.add(rp);

        // skonfiguruj ramkę okna
        JFrame frame = new JFrame("Rysynek z wykorzystaniem Thread.sleep");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.add(drawing);
        frame.pack();
        frame.setVisible(true);

        // główna pętla symulacji
        Toolkit toolkit = frame.getToolkit();
        while (true) {

            // zaktualizuj rysunek
            toolkit.sync();
            drawing.step();

            // opóźnij symulację
            try {
                Thread.sleep(1000 / 30);
            } catch (InterruptedException e) {
                // nie rób nic
            }
        }
    }

}
