import java.util.Arrays;

/**
 * Wielokąt wirujący wokół swojego środka.
 */
public class RotatingPolygon extends RegularPolygon {

    private int xmid;
    private int ymid;

    private int angle;  // w stopniach

    private int[] x0;   // oryginalne współrzędne x
    private int[] y0;   // oryginalne współrzędne y

    /**
     * Konstruuje wirujący wielokąt.
     * 
     * @param nsides liczba boków
     * @param radius odległość wierzchołka od środka
     */
    public RotatingPolygon(int nsides, int radius) {
        super(nsides, radius);
        center();
    }

    /**
     * Ustawia punkt obrotu w środku figury.
     */
    public void center() {

        // znajdź średnie wartości x i y
        int xsum = 0;
        int ysum = 0;
        for (int x : xpoints) {
            xsum += x;
        }
        for (int y : ypoints) {
            ysum += y;
        }
        xmid = (int) Math.round(xsum / npoints);
        ymid = (int) Math.round(ysum / npoints);

        // zresetuj kierunek obrotu
        angle = 359;

        // zapisz oryginalne wartości współrzędnych x i y punktów
        x0 = Arrays.copyOf(xpoints, npoints);
        y0 = Arrays.copyOf(ypoints, npoints);
    }

    @Override
    public void step() {
        // zaktualizuj kąt obrotu
        angle = (angle + 1) % 360;
        final double RAD = Math.toRadians(angle);
        final double COS = Math.cos(RAD);
        final double SIN = Math.sin(RAD);

        // przenieś punkty wielokątu
        for (int i = 0; i < npoints; i++) {
            double t = x0[i] - xmid;
            double v = y0[i] - ymid;
            xpoints[i] = (int) Math.round(xmid + t * COS - v * SIN);
            ypoints[i] = (int) Math.round(ymid + t * SIN + v * COS);
        }
    }

    @Override
    public void translate(int deltaX, int deltaY) {
        super.translate(deltaX, deltaY);
        center();
    }

}
