/**
 * Wielokąt odbijający się od ścian .
 */
public class MovingPolygon extends RegularPolygon {

    private int dx;
    private int dy;

    /**
     * Konstruuje poruszający się wielokąt.
     * 
     * @param nsides liczba boków
     * @param radius odległość wierzchołka od środka
     */
    public MovingPolygon(int nsides, int radius) {
        super(nsides, radius);
        dx = 10;
        dy = 5;
    }

    /**
     * @param dx liczba pikseli, o które należy się przesunąć w lewo lub w prawo
     */
    public void setDx(int dx) {
        this.dx = dx;
    }

    /**
     * @param dy liczba pikseli, o które należy się przesunąć w górę lub w dół
     */
    public void setDy(int dy) {
        this.dy = dy;
    }

    @Override
    public void step() {

        // wykryj krawędzie
        for (int i = 0; i < npoints; i++) {
            if (xpoints[i] < 0 || xpoints[i] > 800) {
                dx *= -1;
                break;
            }
        }
        for (int i = 0; i < npoints; i++) {
            if (ypoints[i] < 0 || ypoints[i] > 600) {
                dy *= -1;
                break;
            }
        }

        // przesuń o jeden krok
        translate(dx, dy);
    }

}
