import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;

/**
 * Rysuje kolekcję aktorów.
 */
public class Drawing extends Canvas {

    private ArrayList<Actor> list;

    /**
     * Konstruuje rysunek o podanej wielkości.
     * 
     * @param width szerokość w pikselach
     * @param height wysokość w pikselach
     */
    public Drawing(int width, int height) {
        setSize(width, height);
        setBackground(Color.WHITE);
        list = new ArrayList<Actor>();
    }

    /**
     * Dodaje nowego aktora do rysunku.
     * 
     * @param actor obiekt do dodania
     */
    public void add(Actor actor) {
        list.add(actor);
    }

    /**
     * Pobiera bieżących aktorów w formie tablicy.
     * 
     * @return tablica obiektów aktorów
     */
    public Object[] getActors() {
        return list.toArray();
    }

    /**
     * Rysuje wszystkich aktorów na kanwie.
     * 
     * @param g kontekst graficzny
     */
    @Override
    public void paint(Graphics g) {
        for (Actor actor : list) {
            actor.draw(g);
        }
    }

    /**
     * Wywołuje metodę step na rzecz każdego aktora i aktualizuje rysunek.
     */
    public void step() {
        for (Actor actor : list) {
            actor.step();
        }
        repaint();
    }

}
