import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.Timer;

/**
 * Płynniejsza wersja programu Sim2 wykorzystująca timer.
 */
public class Sim3 implements ActionListener {

    private Drawing drawing;
    private Toolkit toolkit;

    /**
     * Konfiguracja rysunku i ramki okna.
     */
    public Sim3() {
        // utwórz kilka wielokątów foremnych
        BlinkingPolygon bp = new BlinkingPolygon(3, 20, Color.BLUE);
        MovingPolygon mp = new MovingPolygon(8, 30);
        RotatingPolygon rp = new RotatingPolygon(5, 40);

        // przenieś je w różne miejsca ekranu
        bp.translate(50, 50);
        mp.translate(100, 100);
        rp.translate(200, 200);

        // utwórz rysunek, dodaj wielokąty
        drawing = new Drawing(800, 600);
        drawing.add(bp);
        drawing.add(mp);
        drawing.add(rp);

        // skonfiguruj ramkę okna
        JFrame frame = new JFrame("Rysunek z wykorzystaniem ActionListenera");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.add(drawing);
        frame.pack();
        frame.setVisible(true);
        toolkit = frame.getToolkit();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        toolkit.sync();
        drawing.step();
    }

    /**
     * Tworzy i uruchamia timer.
     *
     * @param args argumenty wiersza poleceń
     */
    public static void main(String[] args) {
        Sim3 sim = new Sim3();
        Timer timer = new Timer(1000 / 30, sim);
        timer.start();
    }

}
