import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;

/**
 * Specjalizacja klasy Polygon, która zapewnia obiektowi kolor i możliwość rysowania się na ekranie.
 */
public class DrawablePolygon extends Polygon implements Actor {

    public Color color;

    /**
     * Tworzy pusty wielokąt.
     */
    public DrawablePolygon() {
        super();
        color = Color.GRAY;
    }

    /**
     * Rysuje wielokąt na ekranie.
     * 
     * @param g kontekst graficzny
     */
    public void draw(Graphics g) {
        g.setColor(color);
        g.fillPolygon(this);
    }

    @Override
    public void step() {
        // nie rób nic
    }

    /**
     * Testuje kod tworzący obiekt klasy ColorPolygon.
     * 
     * @param args argumenty wiersza poleceń
     */
    public static void main(String[] args) {
        DrawablePolygon p = new DrawablePolygon();
        p.addPoint(57, 110);
        p.addPoint(100, 35);
        p.addPoint(143, 110);
        p.color = Color.GREEN;
    }

}
