import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

/**
 * Rysuje kolekcję kretów i nasłuchuje zdarzeń pochodzących od myszy.
 */
public class MoleHill extends Drawing implements MouseListener {

    /**
     * Konstruuje interaktywny rysunek o podanej wielkości.
     * 
     * @param width szerokość w pikselach
     * @param height wysokość w pikselach
     */
    public MoleHill(int width, int height) {
        super(width, height);
        addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        for (Object obj : getActors()) {
            if (obj instanceof Mole) {
                Mole mole = (Mole) obj;
                if (mole.contains(x, y)) {
                    mole.whack();
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        // ignoruj
    }

    @Override
    public void mouseExited(MouseEvent e) {
        // ignoruj
    }

    @Override
    public void mousePressed(MouseEvent e) {
        // ignoruj
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        // ignoruj
    }

}
