/**
 * Niezmienny punkt na płaszczyźnie.
 */
public class Point {

    public static final double DELTA = 0.001;

    private final double x;
    private final double y;

    /**
     * Konstruuje punkt w podanej lokalizacji.
     * 
     * @param x współrzędna X
     * @param y współrzędna Y
     */
    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    /**
     * @return współrzędna X
     */
    public double getX() {
        return x;
    }

    /**
     * @return współrzędna Y
     */
    public double getY() {
        return y;
    }

    /**
     * Oblicza odległość między dwoma punktami.
     * 
     * @param pt inny punkt
     * @return odległość euklidesowa
     */
    public double distance(Point pt) {
        double dx = this.x - pt.x;
        double dy = this.y - pt.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    /**
     * Określa, czy dwa punkty są jednakowe.
     * 
     * @param obj inny punkt
     * @return true, jeśli punkty leżą w tym samym miejscu
     */
    public boolean equals(Object obj) {
        if (obj instanceof Point) {
            Point pt = (Point) obj;
            return distance(pt) < DELTA;
        }
        return super.equals(obj);
    }

    /**
     * @return tekstowa reprezentacja punktu
     */
    public String toString() {
        return String.format("(%.1f, %.1f)", this.x, this.y);
    }

}
