/**
 * Symuluje prostą grę w karty.
 */
public class War {

    public static void main(String[] args) {

        // utwórz i potasuj talię
        Deck deck = new Deck();
        deck.shuffle();

        // podziel talię na dwa stosy
        Pile p1 = new Pile();
        p1.addDeck(deck.subdeck(0, 25));
        Pile p2 = new Pile();
        p2.addDeck(deck.subdeck(26, 51));

        // dopóki obydwa stosy nie są puste
        while (p1.size() > 0 && p2.size() > 0) {
            Card c1 = p1.popCard();
            Card c2 = p2.popCard();

            // porównaj karty
            int diff = c1.getRank() - c2.getRank();
            if (diff > 0) {
                p1.addCard(c1);
                p1.addCard(c2);
            } else if (diff < 0) {
                p2.addCard(c1);
                p2.addCard(c2);
            } else {
                // jest remis... wyciągnij jeszcze cztery karty
            }
        }

        // wyświetl zwycięzcę
        if (p1.size() > 0) {
            System.out.println("Gracz 1 wygrywa!");
        } else {
            System.out.println("Gracz 2 wygrywa!");
        }
    }

}
