// Class CSSerial
using System;
using System.IO;
using System.Xml;
using System.Xml.Serialization;

namespace CSSerial
{
    class Program
    {
        static void Main(string[] args)
        {
            Program myProgram = new Program();
        }

        public Program()
        {
            Serialize();
            DeSerialize();
        }
        
        public void Serialize()
        {
            Person[] myPeople = new Person[3];
            myPeople[0] = new Person("John Q. Public", 32, 95);
            myPeople[1] = new Person("Jacob M. Smith", 35, 67);
            myPeople[2] = new Person("Joe L. Jones", 65, 77);
            XmlSerializer mySerializer = new XmlSerializer(typeof(Person[]));
            TextWriter myWriter = new StreamWriter("person.xml");
            mySerializer.Serialize(myWriter, myPeople);
            myWriter.Close();
        }

        public void DeSerialize()
        {
            Person[] myRestoredPeople;
            XmlSerializer mySerializer = new XmlSerializer(typeof(Person[]));
            TextReader myReader = new StreamReader("person.xml");
            myRestoredPeople = (Person[])mySerializer.Deserialize(myReader);
            Console.WriteLine("My People restored:");
            foreach (Person listPerson in myRestoredPeople)
            {
                Console.WriteLine(listPerson.Name + " is " + listPerson.Age + " years old.");
            }
            Console.WriteLine("Press any key to continue...");
            Console.ReadKey();
        }
    }
}
