Imports System
Imports System.Collections
Imports System.IO
Imports System.Xml
Imports System.Xml.Serialization
Imports System.Net.Sockets
Imports System.Net
Imports System.Text

Public Class Server
    Public Sub New()
        Dim server As TcpListener = Nothing
        Dim client As TcpClient = Nothing
        Try
            'Create our Socket Listener and start it
            server = New TcpListener(IPAddress.Parse("127.0.0.1"), 11111)
            server.Start()

            'Setup our input buffer
            Dim bytes(256) As Byte

            'Loop indefinitely
            While (True)
                'Begin accepting incoming transmissions in block mode
                client = server.AcceptTcpClient()
                Console.WriteLine("Connected!")

                'Open our stream
                Dim stream As NetworkStream = client.GetStream

                'Read all the data of the stream
                Dim i As Integer
                While ((i = stream.Read(bytes, 0, bytes.Length)) = 0)
                    'Prepare a format that the Serializer can read
                    Dim ms As MemoryStream = New MemoryStream(bytes)
                    'Prepare the Serializer
                    Dim myXmlFactory As XmlSerializer = 
				New XmlSerializer(GetType(CheckingAccount))
                    'Create our CheckingAccount from the stream
                    Dim myRestoredAccount As CheckingAccount 
                            = CType(myXmlFactory.Deserialize(ms), CheckingAccount)
                    'Now demonstrate that the object is indeed created
                    Console.WriteLine("Name: {0}, Account Number: {1}", _
                        myRestoredAccount.Name, myRestoredAccount.AccountNumber)
                    'Throw an exception to break from the loop
                    Throw New Exception("ignore")
                End While
            End While
        Catch ex As Exception
            If Not ex.Message = "ignore" Then Console.WriteLine("Exception: {0}", ex)
        Finally
            'Close our resources
            client.Close()
            server.Stop()
        End Try
        Console.WriteLine("Press any key to continue...")
        Console.ReadKey()
    End Sub
End Class
