using System;

namespace TestShop
{
    class TestShop
    {

        public static void Main()
        {

            Shop shop = null;

            Console.WriteLine("Tworzenie egzemplarza klasy PizzaShop:" + "\n");

            shop = new PizzaShop();

            string[] inventory = shop.getInventory();


            // Lista zapasw w magazynie

            for (int i = 0; i < 5; i++)
            {
                Console.WriteLine("Argument" + i + " = " + inventory[i]);
            }


            // Kupowanie

            shop.buyInventory(inventory[1]);

        }

    }



    public abstract class Shop  {

        public void CalculateSaleTax() {

            Console.WriteLine("Obliczanie podatku od sprzeday");

        }

        public abstract string[] getInventory();

        public abstract void buyInventory(string item);

    }

    public interface Nameable {

          string getName();
          void setName(string name);

    }

    public class PizzaShop : Shop , Nameable 
    {

        string _CompanyName;

        string[] foodOfferings = {
            "Pizza",
            "Spaghetti",
            "Saatki",
            "Anitpasto",
            "Calzones"
        };

        public override string[] getInventory() {

            return foodOfferings;

        }

        public override void buyInventory(string item) {

            Console.WriteLine("\nZamwione rzeczy " + item);

        }

        public string getName(){

            return _CompanyName;
        }

        public void setName(string name){

            _CompanyName = name;
        }

    }

    public class DonutShop : Shop , Nameable {

        string _CompanyName;

        string[] menuItems = {
            "Pczki",
            "Babeczki",
            "Ciastka z owocami",
            "Kawa",
            "Herbata"
        };

        public override string[]  getInventory() {

            return menuItems;

        }

        public override void  buyInventory(string item) {

            Console.WriteLine(string.format("\nZamwiono {0}.", item);

        }

        public string getName(){

            return _CompanyName;
        }

        public void setName(string name){

            _CompanyName = name;
        }
    }

}