#!/usr/bin/perl -w

# Skrypt 8.4 - add_user.pl
# Skrypt pozwala dodawa konta do tabeli uzytkownicy.
# Korzysta z danych wprowadzanych przez uytkownika.

# Doczenie potrzebnych moduw.
use strict;
use DBI;

# Wywietlenie komunikatu.
print "Program pozwala dodawa nowe konta uytkownikw.\n\n";
print "Nazwa klienta (ID klienta):\n";

  # Podczenie do bazy danych.
my $dbh = DBI->connect("DBI:mysql:finanse:localhost", 'username', 'password', {RaiseError => 1});

# Wywietlenie uytkownikw i ich identyfikatorw.
my $sql = "SELECT nazwa_klienta, klient_id FROM klienci ORDER BY nazwa_klienta ASC";

# Wykonanie zapytania.
my $sth = $dbh->prepare($sql);

if (defined($sth)) {
  $sth->execute();
  my @row;
  while (@row = $sth->fetchrow_array()) {
    print "$row[0] ($row[1])\n";
  }
}
$sth->finish();

# Wpisywanie danych przez uytkownika.
print "Prosz poda ID klienta: ";
my $client_id = <STDIN>;
print "Prosz poda nazw konta: ";
my $name = <STDIN>;
print "Prosz poda haso dla konta: ";
my $pass1 = <STDIN>;
print "Prosz powtrzy haso dla konta: ";
my $pass2 = <STDIN>;

# Sprawdzenie, czy podane zostay takie same hasa.
while ($pass1 ne $pass2) {
  print "Podane hasa nie s identyczne. Wpisz jeszcze raz!\n";
  
  # Ponowne wczytanie hasa.
  print "Prosz poda haso dla konta: ";
  $pass1 = <STDIN>;
  print "Prosz powtrzy haso dla konta: ";
  $pass2 = <STDIN>;
  
} # Koniec ptli WHILE.

# Wykonanie zapytania.
$sql = "INSERT INTO uzytkownicy (klient_id, nazwa, haslo) VALUES ($client_id, AES_ENCRYPT('$name', 'w1cKet'), SHA1('$pass1'))";
my $affected = $dbh->do($sql);

# Raportowanie stanu wykonania zapytania.
if ($affected == 1) {
  print "Konto logowania zostao dodane! \n";
} else {
  print "Konto logowania nie moe by dodane! \n";
}

# Odczenie.
$dbh->disconnect;
