#!/usr/bin/perl -w

# Skrypt 8.5 - add_invoice.pl
# Skrypt dodaje faktury do tabeli faktury.
# Korzysta z danych wprowadzanych przez uytkownika.

# Doczenie potrzebnych moduw.
use strict;
use DBI;

# Wyietlenie komunikatu.
print "Program pozwala dodawa faktury do bazy danych.\n\n";
print "Nazwa klienta (ID klienta):\n";

# Podczenie do bazy danych.
my $dbh = DBI->connect("DBI:mysql:finanse:localhost", 'username', 'password', {RaiseError => 1});

# Wywietlenie uytkownikw i ich identyfikatorw.
my $sql = "SELECT nazwa_klienta, klient_id FROM klienci ORDER BY nazwa_klienta ASC";

# Wykonanie zapytania.
my $sth = $dbh->prepare($sql);

if (defined($sth)) {
  $sth->execute();
  my @row;
  while (@row = $sth->fetchrow_array()) {
    print "$row[0] ($row[1])\n";
  }
}
$sth->finish();

# Wpisywanie danych przez uytkownika.
print "Prosz poda ID klienta: ";
my $client_id = <STDIN>;
print "Prosz poda warto faktury: ";
my $amount = <STDIN>;
print "Prosze poda opis faktury: ";
my $desc = <STDIN>;

# Wykonanie zapytania.
$sql = "INSERT INTO faktury (klient_id, wartosc_faktury, opis_faktury) VALUES ($client_id, $amount, '$desc')";
my $affected = $dbh->do($sql);

# Raportowanie stanu wykonania zapytania.
if ($affected == 1) {
  print "Zostala utworzona faktura nr " . $dbh->{'mysql_insertid'} . "\n";
} else {
  print "Nie mona utworzy faktury! \n";
}

# Odczenie.
$dbh->disconnect;
