#!/usr/bin/perl -w

# Skrypt 8.8 - add_categories.pl
# Skrypt pozwala dodawa kategorie do tabeli wydatki_kategorie.
# Korzysta z danych wprowadzonych przez uytkownika.

# Doczenie potrzebnych moduw.
use strict;
use DBI;

# Wywietlenie komunikatu.
print "Program pozwala dodawa kategorie wydatkw.\n\n";

# Podczenie do bazy danych.
my $dbh = DBI->connect("DBI:mysql:finanse:localhost", 'username', 'password', {RaiseError => 1});

# Przygotowanie zapytania.
my $sth = $dbh->prepare("INSERT INTO wydatki_kategorie (kategoria_wydatku) VALUES (?)");

if (defined($sth)) {

  # Pobranie pierwszej kategorii.
  print "Podaj kategori wydatku lub wpisz 'q' aby zakoczy: ";
  chop (my $cat = <STDIN>);
  
  while ($cat ne "q") {
    
    # Wykonanie zapytania.
    $sth->execute($cat);
    if ($sth->err()) {
      print "Kategoria wydatku nie moe by dodana.\n\n";
      # W razie potrzeby wywietl bd MySQL.
      # exit() ?
    } else {
      print "Kategoria wydatku zostaa dodana.\n\n";
    }
    
    # Powtrne pobranie kategorii.
    print "Podaj kategori wydatku lub wpisz 'q' aby zakoczy: ";
    chop ($cat = <STDIN>);

  }

}

# Odczenie.
$dbh->disconnect;
