// Super proste wyszukiwanie - wielkość liter nie ma znaczenia, przeszukiwane są wszystkie pola tekstowe (v2)
db.books.find({$text: {$search: 'actions'}},{title:1})

{ "_id" : 755, "title" : "MongoDB in Action, Second Edition" }
{ "_id" : 17, "title" : "MongoDB in Action" }



// Wyszukiwanie z użyciem OR - plus słowa ze stop-listy.
db.books.find({$text: {$search: 'MongoDB in Action'}},{title:1})

// Wynik.

//    { "_id" : 256, "title" : "Machine Learning in Action" }
//    { "_id" : 146, "title" : "Distributed Agile in Action" }
//    { "_id" : 233, "title" : "PostGIS in Action" }
//    { "_id" : 17, "title" : "MongoDB in Action" }


//**********************************************************************
//          9.4.1 - Bardziej zaawansowane operacje wyszukiwania
//                - tak samo jak dalej, ale bez oceny tekstu.
//**********************************************************************


db.books.
    find({$text: {$search: ' "mongodb" in action'}},           //A
    {_id:0, title:1})

/* Wynik.

{ "title" : "MongoDB in Action" }
{ "title" : "MongoDB in Action, Second Edition" }

*/


db.books.
    find({$text: {$search: ' "mongodb" "second edition" '}},           //A
    {_id:0, title:1})


db.books.
    find({$text: {$search: ' books '}}).
    count()

db.books.
    find({$text: {$search: ' "books" '}}).
    count()


db.books.
    find({$text: {$search: ' "book" '}}).
    count()

  // ******************   Podejście alternatywne - developer.
  
 
db.books.
    find({$text: {$search: ' developers '}}).
    count()

db.books.
    find({$text: {$search: ' "developers" '}}).
    count()

db.books.
    find({$text: {$search: ' "developer" '}}).
    count()  

    
 db.books.
    find({$text: {$search: ' developing '}}).
    count()  
    
    
  // ********************************************************

db.books.
    find({$text: {$search: ' mongodb -second '}},           //A
    {_id:0, title:1})

db.books.
    find({$text: {$search: ' mongodb -"second edition" '}},           //A
    {_id:0, title:1})

db.books.
    find({$text: {$search: ' mongodb '}, status: 'MEAP' },           //A
    {_id:0, title:1, status:1})

// Wyświetlenie wyniku oceny tekstu dla dwóch różnych
// ciągów tekstowych wyszukiwania, które są odpowiednikami.

db.books.
    find({$text: {$search: 'mongodb in action'}},               //A
    {_id:0, title:1, score: { $meta: "textScore" }}).           //B
    limit(4);



db.books.
    find({$text: {$search: 'the mongodb and actions in it'}},   //D
    {_id:0, title:1, score: { $meta: "textScore" }}).
    limit(4);

/********************************  WYNIKI.

> db.books.
    ...     find({$text: {$search: 'mongodb in action'}},               #A
    ...     {_id:0, title:1, score: { $meta: "textScore" }}).           #B
    ...     limit(4);
{ "title" : "Machine Learning in Action", "score" : 16.83933933933934 }
{ "title" : "Distributed Agile in Action", "score" : 19.371088861076345 }
{ "title" : "PostGIS in Action", "score" : 17.67825896762905 }      #C
{ "title" : "MongoDB in Action", "score" : 49.48653394500073 }
>
>
> db.books.
    ...     find({$text: {$search: 'the mongodb and actions in it'}},   #D
    ...     {_id:0, title:1, score: { $meta: "textScore" }}).
    ...     limit(4);
{ "title" : "Machine Learning in Action", "score" : 16.83933933933934 }
{ "title" : "Distributed Agile in Action", "score" : 19.371088861076345 }
{ "title" : "PostGIS in Action", "score" : 17.67825896762905 }      #E
{ "title" : "MongoDB in Action", "score" : 49.48653394500073 }

******************************************* */

// Sortowanie wyników według dopasowania.
db.books.
    find({$text: {$search: 'mongodb in action'}},       //A
         {title:1, score: { $meta: "textScore" }}).     //B
    sort({ score: { $meta: "textScore" } })             //C

/* Wynik.

{ "_id" : 17, "title" : "MongoDB in Action", "score" : 49.48653394500073 }
{ "_id" : 186, "title" : "Hadoop in Action", "score" : 24.99910329985653 }
{ "_id" : 560, "title" : "HTML5 in Action", "score" : 23.02156177156177 }

*/


//**********************************************************************
//           - Wyszukiwanie złożone WRAZ z uwzględnieniem oceny tekstu.
//**********************************************************************


db.books.
    find({$text: {$search: ' "mongodb" in action'}},           //A
    {_id:0, title:1, score: { $meta: "textScore" }})

/* Wynik.

{ "title" : "MongoDB in Action", "score" : 49.48653394500073 }
{ "title" : "MongoDB in Action, Second Edition", "score" : 12.5 }

*/


// ZAAWANSOWANE (tego nie znajdziesz w książce)
// Szukane będą wszystkie książki zawierające mongodb LUB books.
// Następnie każdy dokument będzie sprawdzony pod kątem słowa "mongodb".
// To nie zawsze jest efektywne - na przykład jeśli słowo 'book' znajduje się
// w ciągu tekstowym wyszukiwania, wtedy zwrócone będą niemalże wszystkie
// książki w kolekcji, ponieważ praktycznie każda z nich zawiera to słowo.
// Dalej prawie wszystkie książki będą znalezione za pomocą indeksu,
// a następnie w każdej z nich będzie szukane słowo "mongo".
// Wydaje się, że można to zrobić znacznie efektywniej. Dlatego też być
// może rozwiązanie zostanie zmienione w kolejnych wydaniach.


db.books.
    find({$text: {$search: ' "mongodb" book'}},           //A
    {_id:0, title:1, score: { $meta: "textScore" }}).explain()


/* Wynik.

> db.books.count()
431
> db.books.
    ...     find({$text: {$search: ' "mongodb" book'}},           //A
    ...     {_id:0, title:1, score: { $meta: "textScore" }}).explain()
{
    "cursor" : "TextCursor",
    "n" : 2,
    "nscannedObjects" : 414,
    "nscanned" : 416,
    "nscannedObjectsAllPlans" : 414,
    "nscannedAllPlans" : 416,
    "scanAndOrder" : false,
    "nYields" : 6,
    "nChunkSkips" : 0,
    "millis" : 15,
    "server" : "D830J:27017",
    "filterSet" : false
}

*/


db.books.
    find({$text: {$search: ' "mongodb" "second edition" '}},           //A
    {_id:0, title:1, score: { $meta: "textScore" }})


db.books.
    find({$text: {$search: ' books '}}).
    count()


db.books.
    find({$text: {$search: ' "books" '}}).
    count()


db.books.
    find({$text: {$search: ' "book" '}}).
    count()


db.books.
    find({$text: {$search: ' mongodb -second '}},           //A
    {_id:0, title:1, score: { $meta: "textScore" }})

db.books.
    find({$text: {$search: ' mongodb -"second edition" '}},           //A
    {_id:0, title:1, score: { $meta: "textScore" }})

db.books.
    find({$text: {$search: ' mongodb '}, status: 'MEAP' },           //A
    {_id:0, title:1, status:1, score: { $meta: "textScore" }})