// Sekcja 6.4.1. Funkcje ciągu tekstowego.

// $substr konwertuje wartości na ciągi tekstowe.
db.orders.aggregate([
    {$unwind: '$line_items'},
    {$project: {
        'line_items.name': 1,
        orderQuantity:
        {$substr:['$line_items.quantity',0,10]}}},
    {$project: {
        orderSummary:
        {$concat: ['$orderQuantity', ' ', '$line_items.name']}}}
])

//    /* Oczekiwane wyniki.
//
//     { "_id" : ObjectId("6a5b1476238d3b4dd5000048"),
//     "orderSummary" : "1 Bardzo duża taczka" }
//     { "_id" : ObjectId("6a5b1476238d3b4dd5000048"),
//     "orderSummary" : "2 Gumowe rękawice robocze, kolor czarny" }
//
//     */

// Przykład użycia strcmp.
db.users.aggregate([
    {$match: {username: 'kbanker'}},
    {$project:
    {firstStringLT: {$strcasecmp:['ABANKER','$username']},
        firstStringEQ: {$strcasecmp:['kbanker','$username']},
        firstStringGT: {$strcasecmp:['ZBANKER','$username']}
    }
    }
])

//    /* Oczekiwane wyniki.
//
//     { "_id" : ObjectId("4c4b1476238d3b4dd5000001"),
//     "firstStringLT" : -1,
//     "firstStringEQ" : 0,
//     "firstStringGT" : 1 }
//
//     */


db.users.aggregate([
    {$match: {username: 'kbanker'}},
    {$project:
    {firstStringLT: {$cmp:['ABANKER','$username']},
        firstStringEQ: {$cmp:['kbanker','$username']},
        firstStringGT: {$cmp:['ZBANKER','$username']}
    }
    }
])

//    /* Oczekiwane wyniki.
//
//     { "_id" : ObjectId("4c4b1476238d3b4dd5000001"),
//     "firstStringLT" : -1,
//     "firstStringEQ" : 0,
//     "firstStringGT" : -1
//     }
//
//     */