
// *********** 2.2.2 Indeksowanie i polecenie Explain *****************************
db.numbers.find({num: {"$gt": 199995}}).explain()

/*  Wynik podobny do poniższego: 
{                                          
  "cursor" : "BasicCursor",          
  "isMultiKey" : false,              
  "n" : 4,                      // Liczba dokumentów zwróconych w wyniku.      
  "nscannedObjects" : 200000,        
  "nscanned" : 200000,               
  "nscannedObjectsAllPlans" : 200000,
  "nscannedAllPlans" : 200000,       
  "scanAndOrder" : false,            
  "indexOnly" : false,               
  "nYields" : 0,                     
  "nChunkSkips" : 0,                 
  "millis" : 171,               // Ilość czasu potrzebna na wykonanie zapytania.      
  "indexBounds" : { },                                 
  "server" : "hostname:27017"    
}
*/

// Utworzenie indeksu.
db.numbers.ensureIndex({num: 1})

// Sprawdzenie indeksu.
db.numbers.getIndexes()

// Wynik działania explain() dla zindeksowanej kolekcji.
db.numbers.find({num: {"$gt": 199995 }}).explain()

/* Wynik podobny do poniższego: 

{                                                      
  "cursor" : "BtreeCursor num_1",   #A// Użycie indeksu num_1.            
  "isMultiKey" : false,                          
  "n" : 4,                          #B// Zwrócone zostały 4 dokumenty.             
  "nscannedObjects" : 4,                         
  "nscanned" : 4,                   #C// Przeskanowane zostały jedynie 4 dokumenty.                          
  "nscannedObjectsAllPlans" : 4,                 
  "nscannedAllPlans" : 4,                        
  "scanAndOrder" : false,                        
  "indexOnly" : false,                           
  "nYields" : 0,                                 
  "nChunkSkips" : 0,                             
  "millis" : 0,                     #D// Znacznie szybciej!             
  "indexBounds" : {                              
    "num" : [                              
      [                              
        199995,                
        1.7976931348623157e+308
      ]                              
    ]                                      
  },                                             
  "server" : "hostname:27017"                
}

*/

// ***************** 2.3.1 Pobranie informacji o bazie danych *****************************

// Wyświetlenie baz danych.
show dbs

// Wyświetlenie kolekcji w bieżącej bazie danych.
show collections

// Informacje szczegółowe o bazie danych.
db.stats()

/* Wynik podobny do poniższego: 
{                                           
  "db" : "tutorial",                      
  "collections" : 4,                  
  "objects" : 200010,                 
  "avgObjSize" : 36.00065996700165,   
  "dataSize" : 7200492,               
  "storageSize" : 11268096,           
  "numExtents" : 10,                  
  "indexes" : 3,                      
  "indexSize" : 11560864,             
  "fileSize" : 201326592,             
  "nsSizeMB" : 16,                    
  "dataFileVersion" : {               
    "major" : 4,                
    "minor" : 5                 
  },                                  
  "ok" : 1                            
}  
                                         
*/

// Dane statystyczne dla jednej kolekcji.
db.numbers.stats()

/* Wynik podobny do poniższego 
{                                    
  "ns" : "tutorial.numbers",       
  "count" : 200000,            
  "size" : 7200036,            
  "avgObjSize" : 36.00018,     
  "storageSize" : 11255808,    
  "numExtents" : 7,            
  "nindexes" : 2,              
  "lastExtentSize" : 5664768,  
  "paddingFactor" : 1,         
  "systemFlags" : 1,           
  "userFlags" : 0,             
  "totalIndexSize" : 11552688, 
  "indexSizes" : {             
    "_id_" : 6508096,    
    "num_1" : 5044592    
  },                           
  "ok" : 1                     
}                                    

*/

// ******************* 2.3.2 Jak działają polecenia? ******************************


// db.stats() to jest polecenie pomocnicze dla poniższego
db.runCommand( {dbstats: 1} )


// db.numbers.stats() to jest polecenie pomocnicze dla poniższego
db.runCommand( {collstats: "numbers"} )

// Wyświetlenie definicji funkcji, na przykład runCommand - wpisz bez nawiasu (). 
db.runCommand

// Dochodzimy do tej wersji polecenia db.numbers.stats().
db.$cmd.findOne( {collstats: "numbers"} );


// **************** 2.4 Uzyskiwanie pomocy **********************

// Na czym polecega działanie tego polecenia save?
db.numbers.save({num: 123123123})

// Wyświetlenie kodu funkcji save.
db.numbers.save