#!/bin/bash

export MONGO_DIR=/storage/mongodb
export NUM_LOOPS=16

configs=(
    mmapv1.conf
    wiredtiger-uncompressed.conf
    wiredtiger-snappy.conf
    wiredtiger-zlib.conf
)

sudo echo "Otrzymano uprawnienia użytkownika root."

cd $MONGO_DIR
for config in "${configs[@]}"; do
    echo "===== PRZETWARZANIE $config ====="
    echo "Usunięcie zawartości buforów w pamięci"
    sync
    echo 3 | sudo tee /proc/sys/vm/drop_caches

    echo -ne "Uruchomienie demona mongod... "
    T="$(date +%s)"
    ./bin/mongod --config configs/$config &

    # Oczekiwanie na uruchomienie MongoDB.
    while [ 1 ]; do
        ./bin/mongostat -n 1 > /dev/null 2>&1
        if [ "$?" -eq 0 ]; then
            break
        fi    
        sleep 2
    done
    T="$(($(date +%s)-T))"
    echo "operacja trwała $T sekund"

    rm -f timings-${config}.txt
    T="$(date +%s)"
    for l in $(seq 1 $NUM_LOOPS); do
        echo -ne "\rPrzetwarzanie danych, iteracja $l"
        /usr/bin/time -f "%e" -o timings-${config}.txt -a --quiet ./bin/mongo benchmark --quiet read.js >/dev/null 2>&1
    done
    T="$(($(date +%s)-T))"

    echo
    echo "Wydajność wstawiania danych dla konfiguracji $config: $T sekund"

    echo -ne "Zamykanie serwera... "
    T="$(date +%s)"
    ./bin/mongo admin --quiet --eval "db.shutdownServer({force: true})" >/dev/null 2>&1

    while [ 1 ]; do
        pgrep -U $USER mongod > /dev/null 2>&1
        if [ "$?" -eq 1 ]; then
            break
        fi    
        sleep 1
    done
    T="$(($(date +%s)-T))"
    echo "operacja trwała $T sekund"
done
