require 'rubygems'
require 'mongo'

# Wczytujemy 'names' z katalogu, w którym znajduje się skrypt. Dlatego też
# przed podjęciem próby wczytywania pliku dodajemy wspomniany katalog do
# ścieżki wyszukiwania, aby skrypt mógł go znaleźć.
$LOAD_PATH.unshift(File.expand_path(File.dirname(__FILE__))) \
    unless $LOAD_PATH.include?(File.expand_path(File.dirname(__FILE__)))
require 'names'

# Nawiązanie połączenia z MongoDB.
@con  = Mongo::MongoClient.new("localhost", 40000)

# Utworzenie obiektu kolekcji dla "cloud-docs.spreadsheets".
@col  = @con['cloud-docs']['spreadsheets']

# Przykładowe dane.
@data = "abcde" * 1000

# Zapisz wskazanej liczby dokumentów. "name_count" to liczba różnych nazw
# używanych podczas zapisu arkuszy kalkulacyjnych, natomiast "iterations"
# to liczba dokumentów do zapisana dla każdej osoby.
def write_user_docs(iterations=0, name_count=200)
  iterations.times do |iteration|
    name_count.times do |name_number|
      doc = { :filename => "sheet-#{iteration}",
              :updated_at => Time.now.utc,
              :username => Names::LIST[name_number],
              :data => @data
            }
      @col.insert(doc)
    end
  end
end

# Pobranie argumentów powłoki i wykonanie skryptu.
if ARGV.empty? || !(ARGV[0] =~ /^\d+$/)
  puts "Użycie: load.rb [iteracje] [name_count]"
else
  iterations = ARGV[0].to_i

  if ARGV[1] && ARGV[1] =~ /^\d+$/
    name_count = ARGV[1].to_i
  else
    name_count = 200
  end

  write_user_docs(iterations, name_count)
end
