
// ************* 7.4.1

// Poniższe zapytanie POWINNO zakończyć się niepowodzeniem.
db.products.update({}, {name: "Widły", "$addToSet": {tags: 'tani'}})

// Poprawna wersja, której jednak nigdy nie powinieneś stosować!
db.products.update({},
  {$set: {name: "Widły"}, $addToSet: {tags: 'tani'}})

// Modyfikacja wielu dokumentów.

db.products.update({}, {$addToSet: {tags: 'tani'}}, {multi: true})

// Wyświetlenie wyniku.
db.products.find().pretty()

// Operacja upsert.

db.products.update({slug: 'młotek'}, {$addToSet: {tags: 'tani'}}, {upsert: true})

// Wyświetlenie wyniku. 
db.products.find().pretty()


// **************** 7.4.2 Operatory uaktualnienia.

// Operator $inc.
db.products.update({slug: "szpadel"}, {$inc: {review_count: 1}})
db.users.update({username: "moe"}, {$inc: {password_retires: -1}})

db.readings.update({_id: 324}, {$inc: {temp: 2.7435}})

db.readings.update({_id: 324}, {$inc: {temp: 2.7435}}, {upsert: true})

// Wyświetlenie wyniku.
db.readings.findOne({_id: 324})

// Operatory $set i $unset.
db.readings.update({_id: 324}, {$set: {temp: 97.6}})
db.readings.update({_id: 325}, {$set: {temp: {f: 212, c: 100}}})
db.readings.update({_id: 326}, {$set: {temps: [97.6, 98.4, 99.1]}})

db.readings.update({_id: 324}, {$unset: {temp: 1}})

// ***************** Wstawienie pewnych danych testowych ************** 
// Poniższy kod "zeruje" dane testowe - to czasem użyteczne.
db.readings.remove({_id: 324})
db.readings.remove({_id: 325})
db.readings.remove({_id: 326})
db.readings.insert([{_id: 324, 'temp': 2.7435},
{_id: 325, 'temp': {f: 212, c: 100}},
{_id: 326, temps: [97.6, 98.4, 99.1]}])

// Wyświetlenie wyniku.
 db.readings.find().pretty()
 
// Przykłady operatorów $unset i $pop.
db.readings.update({_id: 325}, {$unset: {'temp.f': 1}})
db.readings.update({_id: 326}, {$pop: {temps: -1}})

// Użycie operatora $unset podczas pracy z tablicami.
db.readings.update({_id: 325}, {$unset: {'temp.f': 1}})
db.readings.update({_id: 326}, {$unset: {'temps.0': 1}}) 

// Operator $rename.
db.readings.update({_id: 324}, {$rename: {'temp': 'temperatura'}})
db.readings.update({_id: 325}, {$rename: {'temp.f': 'temp.fahrenheit'}})

// Operator $setOnInsert.
db.products.remove({slug: 'młotek'})
db.products.update({slug: 'młotek'}, {
    $inc: {
      qty: 1
    }, 
    $setOnInsert: {
      state: 'AVAILABLE'
    }
  }, {upsert: true})

// Wynik.
db.products.findOne({slug: 'młotek'})


// ******* Array Update Parameters

// Operatory $push, $pushAll i $each.
db.products.insert({slug: 'szpadel'})
db.products.update({slug: 'szpadel'}, {$push: {tags: 'narzędzia'}})

db.products.find({slug: 'szpadel'}).pretty()

db.products.update({slug: 'szpadel'},
  {$push: {tags: {$each: ['narzędzia', 'brud', 'ogród']}}})

db.products.remove({slug: 'szpadel'})
db.products.insert({slug: 'szpadel'})

db.products.update({slug: 'szpadel'},
  {$pushAll: {'tags': ['narzędzia', 'brud', 'ogród']}})
  
// Operator $slice.
// Utworzenie dokumentu.
db.temps.remove({})
db.temps.insert(
{
  _id: 326, 
  temps: [92, 93, 94]
})

db.temps.find().pretty()

db.temps.update({_id: 326}, {
    $push: {
      temps: {
        $each: [95, 96],
        $slice: -4
      }
    }
  })
  
// Wynik.
db.temps.find({_id: 326})

/* Powinien przedstawiać się następująco.
{
  _id: 326, 
  temps: [93, 94, 95, 96]
}

*/

// Operator $sort.
db.temps.remove({_id: 300})
db.temps.insert(
{
  _id: 300,
  temps: [  
    { day: 6, temp: 90 },
    { day: 5, temp: 95 }
  ]
}
)

db.temps.update({_id: 300}, {
    $push: {
      temps: {
        $each: [
          { day: 7, temp: 92 }
        ],
        $slice: -2,
        $sort: {
          day: 1
        }
      }
    }
  })

// Wyświetlenie wyniku.
db.temps.find({_id: 300})

/* Powinien przedstawiać się następująco.
{
  _id: 300,
  temps: [  
    { day: 6, temp: 90 },
    { day: 7, temp: 92 }
  ]
}
*/

// Operatory $addToSet i $each.
db.products.update({slug: 'szpadel'}, {$addToSet: {'tags': 'narzędzia'}})

db.products.update({slug: 'szpadel'},
  {$addToSet: {tags: {$each: ['narzędzia', 'brud', 'stal']}}})

// Operator $pop.
db.products.update({slug: 'szpadel'}, {$pop: {'tags': 1}})

db.products.update({slug: 'szpadel'}, {$pop: {'tags': -1}})

db.products.find({slug: 'szpadel'}).pretty()

// Operator $bit.
// Przykład.
db.permissions.remove({_id: 16,})
db.permissions.insert({
  _id: 16,
  permissions: NumberInt(4)
})

db.permissions.update({_id: 16}, {$bit: {permissions: {or: NumberInt(2)}}})

// Wyświetlenie wyniku.
db.permissions.find({_id: 16})

/* Powinieneś otrzymać:
{
  _id: 16,
  permissions: 6
}
*/

// Operatory $pull i $pullAll.
db.products.update({slug: 'szpadel'}, 
  {$pullAll: {'tags': ['brud', 'ogród']}})

// Przykładowe dane.
db.readings.remove({_id: 326})
db.readings.insert({_id: 326, temps: [97.6, 98.4, 100.5, 99.1, 101.2]})

db.readings.update({_id: 326}, {$pull: {temps: {$gt: 100}}})

// Wyświetlenie wyniku.
db.readings.find({_id: 326})

// Powinieneś otrzymać {_id: 326, temps: [97.6, 98.4, 99.1]}

// ************ Uaktualnienia pozycyjne.

// Przykład wstawienia danych.
db.orders.remove({_id: ObjectId("6a5b1476238d3b4dd5000048")})
db.orders.insert(
{ 
  _id: ObjectId("6a5b1476238d3b4dd5000048"),
  line_items: [
    { 
      _id: ObjectId("4c4b1476238d3b4dd5003981"),
      sku: "9092",
      name: "Bardzo duża taczka",
      quantity: 1,
      pricing: {
        retail: 5897,
        sale: 4897
      }
    },
    { 
      _id: ObjectId("4c4b1476238d3b4dd5003981"),
      sku: "10027",
      name: "Gumowe rękawice robocze, kolor czarny",
      quantity: 2,
      pricing: {
        retail: 1499,
        sale: 1299
      }
    }
  ]
}
)

// Wyszukanie.
db.orders.find(query).pretty()

// Przykład.
query  = {
  _id: ObjectId("6a5b1476238d3b4dd5000048"),
  'line_items.sku': "10027"
}
update = {
  $set: {
    'line_items.$.quantity': 5
  }
}
db.orders.update(query, update)

// Wyświetlenie wyniku.
db.orders.find({_id: ObjectId("6a5b1476238d3b4dd5000048")}).pretty()

// ********************* 7.4.3   Polecenie findAndModify().

doc = db.orders.findAndModify({
     query: {
       user_id: ObjectId("6a5b1476238d3b4dd5000048"),
     },
     update: {
       $set: {
         state: "AUTHORIZING"
       }
     }
   })

// ************** 7.4.4  Usunięcie.

db.reviews.remove({user_id: ObjectId('4c4b1476238d3b4dd5000001')})

db.reviews.remove({})


// ************************* 7.4.5 Współbieżność, niepodzielność i izolacja.

db.reviews.remove({user_id: ObjectId('4c4b1476238d3b4dd5000001'),
  $isolated: true})
  
db.reviews.update({$isolated: true}, {$set: {rating: 0}}, {multi: true})



// ***********************  7.4.6 Uwagi dotyczące wydajności uaktualnienia.
db.tweets.stats()

// Znacznie bardziej realistyczne dane.
db.orders.stats()






