<!DOCTYPE html> 
<html> 
  <head> 
  <meta charset="UTF-8" />
  <title>Tartanator</title> 
  <meta name="viewport" content="width=device-width, initial-scale=1"> 
  <link rel="stylesheet" href="http://code.jquery.com/mobile/1.0rc1/jquery.mobile-1.0rc1.min.css" />
  <link rel="stylesheet" href="css/styles.css" />
  <script src="http://code.jquery.com/jquery-1.6.4.min.js"></script>
  <script type="text/javascript">
    // Trzeba się podpiąć do mobileinit zanim zostanie załadowany framework jQM
    $(document).bind('mobileinit',function(){
      $.mobile.selectmenu.prototype.options.nativeMenu = false;
    });
  </script>
  <script src="http://code.jquery.com/mobile/1.0rc1/jquery.mobile-1.0rc1.min.js"></script>
</head> 
<body> 

<div data-role="page" id="tartan-maker">
  <div data-role="header" data-position="fixed">
  <a href="tartans.html" data-rel="back" data-icon="back" data-role="button">Back</a>
    <h1>Projektant</h1>
  </div><!-- /header -->

    <div data-role="content">  
    <script src="js/tartanator.js"></script>
      <form id="tartanator_form" action="generate.php" method="post">
        <ul data-role="listview" id="tartanator_form_list">
          <li data-role="list-divider">Opowiedz o swoim tartanie</li>
          <li data-role="fieldcontain">
            <label for="tartan_name">Nazwa tartanu</label>
            <input type="text" name="name" id="tartan_name" placeholder="Nazwa tartanu" />
          </li>
          <li data-role="fieldcontain">
            <label for="tartan_info">Informacje o tartanie</label>
            <textarea cols="40" rows="8" name="tartan_info" id="tartan_info" placeholder="Opcjonalny opis tartanu"></textarea>
          </li>
          <li data-role="list-divider">Zdefiniuj kolory</li>
      
          <?php for ($i = 0; $i < 6; $i++): // pola dla 6 kolorów ?>
            <li class="colorset">
              <div data-role="fieldcontain" class="color-input">
              <label class="select" for="color-<?php print $i ?>" data-native-menu="false">
                Kolor
              </label>
                <select name="colors[]" id="color-<?php print $i ?>" >
                  <option value="">Wybierz kolor</option>
                  <option value="#000000">czarny</option>
                  <option value="#ffffff">biały</option>
                  <option value="#cccccc">jasnoszary</option>
                  <option value="#999999">szary</option>
                  <option value="#666666">ciemnoszary</option>
                  <option value="#cc0000">czerwony</option>
                  <option value="#660000">ciemnoczerwony</option>
                  <option value="#FFB6C1">jasnoróżowy</option>
                  <option value="#ff3344">różowy</option>
                  <option value="#FF8C00">pomarańczowy</option>
                  <option value="#FFD700">złoty</option>            
                  <option value="#ffec00">żółty</option>
                  <option value="#9ACD32">żółtozielony</option>
                  <option value="#5b6333">oliwkowy</option>
                  <option value="#00cc00">jasnozielony</option>
                  <option value="#546c18">zieleń łąki</option>
                  <option value="#8FBC8F">jasny szarozielony</option>
                  <option value="#008000">zielony</option>
                  <option value="#126846">niebieskozielony</option>
                  <option value="#B0E0E6">jasnoniebieski</option>
                  <option value="#274086">niebieski</option>
                  <option value="#56565e">szaroniebieski</option>
                  <option value="#3c516c">stalowoniebieski</option>
                  <option value="#001144">ciemnoniebieski</option>
                  <option value="#29292b">bardzo ciemnoniebieski</option>
                  <option value="#4B0082">indygo</option>
                  <option value="#8A2BE2">niebieskofioletowy</option>
                  <option value="#65295f">fioletowy</option>
                  <option value="#cc9966">jasnobrązowy</option>
                  <option value="#996600">brązowy</option>
                  <option value="#615024">ziemisty</option>
                  <option value="#663300">brązowy</option>
                </select>
              </div>
          
              <div data-role="fieldcontain" class="size-input">
                <label for="size-<?php print $i ?>">Liczba ściegów</label>
                <input id="size-<?php print $i ?>" type="range" min="2" step="2" max="72" autocomplete="off" name="sizes[]" value="2" />
                </div>
            </li>
          <?php endfor; ?>
        </ul>

        <ul data-role="listview" data-inset="true" id="colorlist">
        </ul>
        
        <div data-role="fieldcontain">
          <input type="submit" name="buildtartan" id="buildtartan" value="Utwórz!" data-role="button" />
        </div>

      </form>

    </div><!-- /content -->

	<div data-role="footer" data-position="fixed">
		<div data-role="navbar"> 
			<ul> 
				<li><a href="index.html" data-icon="info">O nas</a></li> 
				<li><a href="findevent.php" data-icon="star">Wydarzenia</a></li> 
				<li><a href="tartans.php" data-icon="grid" class="ui-btn-active">Tartany</a></li> 
			</ul> 
		</div><!-- /navbar --> 
	</div><!-- /footer -->
	
</div><!-- /page -->

</body>
</html>
