#ifndef LOGGER_H
#define LOGGER_H
#include <stdbool.h>

/* Rejestruje bieżący znacznik czasu i podany łańcuch znaków. Łańcuch musi być
   poprawny do czasu zwrócenia sterowania przez tę funkcję. Podany moduł określa
   moduł oprogramowania, który wywołał tę funkcję.
*/
void logging(const char* module, const char* text);

/* Umożliwia zapisywanie danych dla podanego modułu. */
bool enableModule(const char* module);

/* Wszystkie późniejsze komunikaty będą zapisywane w standardowym wyjściu. */
void logToStdout();

/* Wszystkie późniejsze komunikaty będą zapisywane w pliku. */
void logToFile();
#endif
