#include "registry.h"
#include <stdio.h>
#include <assert.h>
#include <stdbool.h>
#include <string.h>
#include <stdlib.h>

#define MAX_KEYS 40

struct Key
{
  char key_name[STRING_SIZE];
  char key_value[STRING_SIZE];
};

/* Makro do rejestrowania informacji diagnostycznych i wykonywania instrukcji assert. */
#define logAssert(X)                        \
    if(!(X))                                  \
    {                                       \
      printf("Błąd w wierszu %i", __LINE__); \
      assert(false);                        \
    } 

/* Tablica globalna na poziomie pliku przechowująca wszystkie klucze rejestru. */
static struct Key* key_list[MAX_KEYS]; 

RegKey createKey(char* key_name)
{
  logAssert(key_name != NULL)
  logAssert(STRING_SIZE > strlen(key_name))

  RegKey newKey = calloc(1, sizeof(struct Key));
  if(newKey == NULL)
    return NULL;

  strcpy(newKey->key_name, key_name);
  return newKey;
}

void storeValue(RegKey key, char* value)
{
  logAssert(key != NULL && value != NULL)
  logAssert(STRING_SIZE > strlen(value))

  strcpy(key->key_value, value);
}

RegError releaseKey(RegKey key)
{
  logAssert(key != NULL)

  int i;
  for(i=0; i<MAX_KEYS; i++)
    if(key_list[i] == NULL)
    {
      key_list[i] = key;
      return OK;
    }

  return CANNOT_ADD_KEY;
}
