#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <dirent.h>
#include <assert.h>
#include <stdbool.h>


#define ELEMENT_SIZE 255
#define MAX_ELEMENTS 10

typedef struct
{
  bool occupied;
  char memory[ELEMENT_SIZE];
}PoolElement;

static PoolElement memory_pool[MAX_ELEMENTS];

void* poolTake(size_t size)
{
  if(size <= ELEMENT_SIZE)
  {
    for(int i=0; i<MAX_ELEMENTS; i++)
    {
      if(memory_pool[i].occupied == false)
      {
        memory_pool[i].occupied = true;
        return &(memory_pool[i].memory);
      }
    }
  }
  return NULL;
}

void poolRelease(void* pointer)
{
  for(int i=0; i<MAX_ELEMENTS; i++)
  {
    if(&(memory_pool[i].memory) == pointer)
    {
      memory_pool[i].occupied = false;
      return;
    }
  }
}


/* Alokuje pamięć i sprawdza, czy pamięć jest dostępna. */
void* mallocWrapper(size_t size)
{
  void* pointer = malloc(size);
  assert(pointer);
  return pointer;
}

/* Zwalnia pamięć podanego wskaźnika "pointer". */
void freeWrapper(void *pointer)
{
  free(pointer);
}




/* Szyfr Cezara ze stałym przesunięciem 3.
   Parametr 'text' musi zawierać tekst z samymi wielkimi literami i bez polskich znaków.
   Parametr 'length' musi zawierać długość tekstu
   z pominięciem końcowego znaku NULL. */
void caesar(char* text, int length)
{
   int i;
   for(i=0; i<length; i++)
   {
     text[i] = text[i]+3;

     /* Po dojściu do ostatniej litery należy zacząć od początku.  */
     if(text[i] > 'Z') 
     {
       text[i] = text[i] - 'Z' + 'A' - 1;
     }
   }
}


/* Zwraca długość pliku o nazwie 'filename'. */
int getFileLength(char* filename)
{
  FILE * f = fopen (filename, "r");
  fseek (f, 0, SEEK_END);
  int file_length = ftell (f);  /* Kopiuje wartość size_t do zmiennej typu int. */
  fclose(f);
  return file_length;
}



/* Zapisuje zawartość pliku o nazwie 'filename' w buforze
   'buffer' (o długości co najmniej 'file_length'). */
void readFileContent(char* filename, char* buffer, int file_length)
{
  FILE * f = fopen (filename, "r");
  fseek (f, 0, SEEK_SET);
  int read_elements = fread (buffer, 1, file_length, f);
  buffer[read_elements] = '\0';
  fclose (f);
}


/* Dla podanego pliku 'filename' funkcja wczytuje tekst i wyświetla jego
   odpowiednik po zaszyfrowaniu szyfrem Cezara. Ta funkcja odpowiada za
   alokację i dealokację buforów potrzebnych do przechowywania
   zawartości pliku. */
void encryptCaesarFile(char* file_name)
{
  char* text = NULL;
  int size = getFileLength(file_name);
  if(size>0)
  {
  text = mallocWrapper(size);
  if(text != NULL)
  {
    readFileContent(file_name, text, size);
    caesar(text, strnlen(text, size));
    printf("Zaszyfrowany tekst: %s", text);  
  } 
  freeWrapper(text);
  text = NULL;
  }
}

#define MAX_FILENAME_SIZE ELEMENT_SIZE

/* Wyświetla nazwę pliku 'file_name' zaszyfrowaną szyfrem Cezara.
   Ta funkcja odpowiada za alokację i dealokację potrzebnych buforów
   na zawartość pliku.
   Uwaga: w nazwie pliku można używać tylko wielkich liter, a szyfr Cezara powoduje 
   też modyfikację znaku '.'. */
void encryptCaesarFilename(char* file_name)
{
  char* buffer = poolTake(MAX_FILENAME_SIZE);
  strncpy(buffer, file_name, MAX_FILENAME_SIZE);
  caesar(buffer, strnlen(buffer, MAX_FILENAME_SIZE));
  printf("\nZaszyfrowana nazwa pliku: %s ", buffer);  
  poolRelease(buffer);
}


/* Ta funkcja wczytuje tekst z wszystkich plików z bieżącego katalogu 
   i wyświetla tekst zaszyfrowany szyfrem Cezara. */
void encryptDirectoryContent()
{
  struct dirent *directory_entry;
  DIR *directory = opendir(".");
  while ((directory_entry = readdir(directory)) != NULL)
  {
    encryptCaesarFilename(directory_entry->d_name);
    encryptCaesarFile(directory_entry->d_name);
  }
  closedir(directory);
}

int main()
{
  chdir(".\\text");
  encryptDirectoryContent();
  printf("\nZ powodzeniem zaszyfrowano zawartość katalogu");
}

