#include <stdio.h>
#include <stdlib.h>
#include "driver.h"


void ethShow()
{
  struct EthernetDriverStat eth_stat = ethernetDriverGetStatistics();
  printf("Liczba otrzymanych pakietów: %i\n", eth_stat.received_packets);
  printf("Liczba wysłanych pakietów: %i\n", eth_stat.total_sent_packets);
  printf("Wysłane pakiety - powodzenie: %i\n",eth_stat.successfully_sent_packets);
  printf("Wysłane pakiety - niepowodzenie: %i\n", eth_stat.failed_sent_packets);

  const struct EthernetDriverInfo* eth_info = ethernetDriverGetInfo();
  printf("Nazwa sterownika: %s\n", eth_info->name);
  printf("Opis sterownika: %s\n", eth_info->description);

  struct IpAddress ip;
  ethernetDriverGetIp(&ip);
  printf("Adres IP: %s\n", ip.address);

  struct Packet* packet = ethernetDriverGetPacket();
  printf("Informacje o pakiecie:");
  fwrite(packet->data, 1, packet->size, stdout);
  free(packet);
}


int main()
{
  ethShow();
  return 0;
}

