/**************************************************************
        Schemat podcze programowanego ukadu
                       +----v----+
                 MCLR [| 1     28|] VDD
                      [| 2     27|] VSS
                      [| 3     26|] RB15 -> DB4        
                      [| 4     25|] RB14 -> DB5
                      [| 5     24|] RB13 -> DB6
GPS TX -> RP2 (U2RXR) [| 6     23|] 
                      [| 7     22|] RB11 -> DB7
                  VSS [| 8     21|] RB10 -> RS
       (8 MHz) / OSCI [| 9     20|] VCAP/VDDCORE
               \ OSCO [|10     19|] DISVREG
                      [|11     18|] RB9 -> EN
                      [|12     17|] 
                  VDD [|13     16|]  
                      [|14     15|] 
                       +---------+
                     PIC24FJ64GB002
***************************************************************/
#include <p24Fxxxx.h>
//definiujemy szybko oscylatora dla funkcji __delay_
#define FCY 16000000UL 
//biblioteka z funkcjami __delay_us i __delay_ms
#include <libpic30.h>

//ustawienia bitw konfiguracyjnych
//1. 
//FWDTEN_OFF - Watchdog wyczony
//JTAGEN_OFF - JTAG wyczony
_CONFIG1(FWDTEN_OFF & JTAGEN_OFF)
//2.
//FNOSC_PRIPLL - ukad taktowany zewntrznym oscylatorem z ptl PLL
//POSCMOD_XT - czstotliwo taktowania oscylatora 8 MHz
//PLLDIV_DIV2 - konieczno podzielenia przez 2 dla moduu USB PLL
_CONFIG2(FNOSC_PRIPLL & POSCMOD_XT & PLLDIV_DIV2)
//////////////////////////////////////
#define TRIS_RS_LCD   TRISBbits.TRISB10
#define TRIS_EN_LCD   TRISBbits.TRISB9
#define TRIS_DB4_LCD  TRISBbits.TRISB15
#define TRIS_DB5_LCD  TRISBbits.TRISB14
#define TRIS_DB6_LCD  TRISBbits.TRISB13
#define TRIS_DB7_LCD  TRISBbits.TRISB11

#define RS_LCD   LATBbits.LATB10
#define EN_LCD   LATBbits.LATB9
#define DB4_LCD  LATBbits.LATB15
#define DB5_LCD  LATBbits.LATB14
#define DB6_LCD  LATBbits.LATB13
#define DB7_LCD  LATBbits.LATB11

#include "lcd.h"
//////////////////////////////////////
char tablica[128];				//tablica danych
//tablice znakowe dla funkcji LCD
char napis1[] = "Szukam...";	//9 znakw
char dane = 0, flaga = 0;		//zmienne modyfikowane w funkcji obsugi przerwania
int kursor;						//zmienna do obsugi tablicy

void __attribute__ ((interrupt, no_auto_psv)) _U2RXInterrupt(void) 
{
	dane = U2RXREG;				//odczytaj dane
	flaga = 1;					//ustaw flag odebranego bajtu
	IFS1bits.U2RXIF = 0;		//czy flag przerwania
}

int main()
{
	/////////////////////////////////////////////////////
	AD1PCFGL = 0xFFFF;			//wszystkie linie cyfrowe

	/////////////////////////////////////////////////////
	//uruchomienie wywietlacza LCD//////////////////////
	WlaczLCD();					//inicjalizacja wywietlacza LCD
	WyswietlLCD(napis1, 9);		//wywietl napis "Szukam..."

	/////////////////////////////////////////////////////
	// obsuga UART
	//remapowanie RP2 dla wejciowej linii U2RX moduu UART2
	//RP2 <- U2RX (linia nr 2)
	RPINR19bits.U2RXR = 2;
	//prdko = 9600 (U2BRG = 16000000/16*9600 - 1)
	U2BRG = 103;
	//wcz obsug przerwania U2RX
	IFS1bits.U2RXIF = 0;		//czy flag przerwania
	IEC1bits.U2RXIE = 1;		//wcz przerwanie
	//wcz modu UART2
	U2MODEbits.UARTEN = 1;

	/////////////////////////////////////////////////////
	//nieskoczona ptla
	kursor = 0;
	for(;;)						
	{
		//czy nadesza nowa wiadomo
		if(flaga)
		{
			flaga = 0;					//zerowanie flagi
			if(dane == '$') kursor = 1;	//szukaj pocztku wiadomoci
			if(kursor>120) kursor = 0;	//zabezpiecz tablic
			if(kursor>0) 
			{
				kursor++;				//inkrementuj kursor
				tablica[kursor] = dane;	//aduj dane do tablicy


				if(kursor>46) kursor = 0;
				if(tablica[20] == 'A')	//jeli dane s poprawne
				{
					//wywietl wsprzdne dugoci
					if((kursor>21)&&(kursor<34))
					{
						UstawKursorLCD(1, kursor-21);
						Wyslij_do_LCD(tablica[kursor]);
					}
					//wywietl wsprzdne szerokoci
					if((kursor>33)&&(kursor<47))
					{
						UstawKursorLCD(2, kursor-33);
						Wyslij_do_LCD(tablica[kursor]);
					}
					//wywietl inf. o danych poprawnych
					{
						UstawKursorLCD(1, 16);
						Wyslij_do_LCD('A');
					}
				}
				else
				//wywietl inf. o danych niepoprawnych
				{
					UstawKursorLCD(1, 16);
					Wyslij_do_LCD('V');
				}
				//szukamy ramki $GPRMC
				//tablica[2] = $, tablica[3] = G, tablica[4] = P
				//tablica[5] = R, tablica[6] = M, tablica[7] = C
				if((kursor == 5)&&(tablica[5]!='R')) kursor = 0;
				if((kursor == 6)&&(tablica[6]!='M')) kursor = 0;
				if((kursor == 7)&&(tablica[7]!='C')) kursor = 0;
			}
		}
	}
}
