;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;        Schemat podcze programowanego ukadu
;                       +----v----+
;                 MCLR [| 1     28|] VDD
;                      [| 2     27|] VSS
;                      [| 3     26|] 
;                      [| 4     25|] 
;                      [| 5     24|] 
;                      [| 6     23|] 
;                      [| 7     22|] 
;                  VSS [| 8     21|] 
;       (8 MHz) / OSCI [| 9     20|] VCAP/VDDCORE
;               \ OSCO [|10     19|] DISVREG
;                      [|11     18|] RB9 -> D2
;                      [|12     17|] RB8 -> D1
;                  VDD [|13     16|] INT0 <- S1
;                      [|14     15|] 
;                       +---------+
;                     PIC24FJ64GB002
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	.include "p24FJ64GB002.inc"
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ustawienia bitw konfiguracyjnych
;1. 
;FWDTEN_OFF - Watchdog wyczony
;JTAGEN_OFF - JTAG wyczony
	config  __CONFIG1,	FWDTEN_OFF & JTAGEN_OFF
;2.
;FNOSC_PRIPLL - ukad taktowany zewntrznym oscylatorem z ptl PLL
;POSCMOD_XT - czstotliwo taktowania oscylatora 8 MHz
;PLLDIV_DIV2 - konieczno podzielenia przez 2 dla moduu USB PLL
	config  __CONFIG2,	FNOSC_PRIPLL & POSCMOD_XT & PLLDIV_DIV2
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; definicje staych
	.equ	procesorek, 16000-6
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; deklaracje symboli globalnych
	.global __reset				;etykieta pierwszej linii kodu
	.global __MathError			;wektor puapki bdu matematycznego
	.global __INT0Interrupt		;wektor przerwania INT0
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; pocztek kodu
__reset:
	mov		#__SP_init, W15		;inicjalizacja wskanika stosu (adres pocztku stosu)
	mov		#__SPLIM_init, W0	;inicjalizacja SPLIM (adres graniczny stosu)
	mov		W0, SPLIM			;W0 -> SPLIM
	nop                         ;konieczna instrukcja nop
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; konfiguracja linii portu B
	bclr	TRISB, #8			;linia RB8 wyjciowa (D1)
	bclr	TRISB, #9			;linia RB9 wyjciowa (D2 - wskanik bdu mat.)
	bclr	LATB, #9			;dioda D2 zgaszona

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; konfiguracja przerwania INT0
	bset	INTCON2, #INT0EP	;reakcja na zbocze opadajce
	bset	IEC0, #INT0IE		;wcz przerwanie INT0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; dane ptli
	mov		#5, W5
	mov		#100, W6

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; nieskoczona ptla
petla:

	;mruganie
	bset	LATB, #8			;RB8 = 1
	mov		#250, W1			;W1 <- 250
	rcall	Czekaj_ms			;czekaj 250 ms

	bclr	LATB, #8			;RB8 = 0
	mov		#250, W1			;W1 <- 250
	rcall	Czekaj_ms			;czekaj 250 ms

	;dzielenie
	repeat	#17					;powtrz 17+1 razy
	div.uw	W6, W5				;Dziel, bracie, dziel!
	dec		W5, W5				;zmniejsz W5

	bra		petla				;skok bezwarunkowy do etykiety ptla
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; podprogram tworzcy opnienie o W1 milisekund
Czekaj_ms:
	mov		#procesorek, W2		;W2 <- FCPU-6
	repeat	W2					;powtrz W2 razy
	nop
	dec		W1, W1				;W1--
	bra		NZ, Czekaj_ms		;wr do ptli, jeli nie byo 0
	return						;powrt z podprogramu
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; obsuga wektorw przerwa i puapek
__MathError:					;wektor puapki bdu matematycznego
	bset	LATB, #9			;zawie diod D2
	bclr	INTCON1, #MATHERR	;wyczy flag puapki bdu
	retfie						;powr z obsugi puapki
	;goto    __MathError    

__INT0Interrupt:				;wektor przerwania INT0
	bclr	LATB, #9			;wyzeruj lini z diod D2
	bclr	IFS0, #INT0IF		;wyczy flag przerwania
	retfie						;powrt z przerwania
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; i to by byo na tyle
.end							;koniec programu
