/**************************************************************
        Schemat podcze programowanego ukadu
                       +----v----+
                 MCLR [| 1     28|] VDD
                      [| 2     27|] VSS
                      [| 3     26|] 
                      [| 4     25|] 
                      [| 5     24|] 
                      [| 6     23|] 
                      [| 7     22|] 
                  VSS [| 8     21|] 
       (8 MHz) / OSCI [| 9     20|] VCAP/VDDCORE
               \ OSCO [|10     19|] DISVREG
                      [|11     18|] RB9 -> D2
                      [|12     17|] RB8 -> D1
                  VDD [|13     16|] INT0 <- S1
                      [|14     15|] 
                       +---------+
                     PIC24FJ64GB002
***************************************************************/
#include <p24Fxxxx.h>

//ustawienia bitw konfiguracyjnych
//1. 
//FWDTEN_OFF - Watchdog wyczony
//JTAGEN_OFF - JTAG wyczony
_CONFIG1(FWDTEN_OFF & JTAGEN_OFF)
//2.
//FNOSC_PRIPLL - ukad taktowany zewntrznym oscylatorem z ptl PLL
//POSCMOD_XT - czstotliwo taktowania oscylatora 8 MHz
//PLLDIV_DIV2 - konieczno podzielenia przez 2 dla moduu USB PLL
_CONFIG2(FNOSC_PRIPLL & POSCMOD_XT & PLLDIV_DIV2)

int licznik;		//zmienna globalna potrzebna do zawiecenia diody D1

//funkcja tworzca opnienie o wielokrotno mikrosekund
//dla taktowania 32 MHz
void Czekaj_us(unsigned long int ile)
{
	//jednokrotne wykonanie ptli zajmuje 16 cykli (1 us)
	while(ile>0) 
	{
		ile--;
		asm("nop");		
		asm("nop");		
		asm("nop");		
		asm("nop");		
		asm("nop");	
		asm("nop");
	}
}

int main()
{
	//konfiguracja linii portu B
	TRISBbits.TRISB7 = 1;		//linia RB7 wejciowa
	TRISBbits.TRISB8 = 0;		//linia RB8 wyjciowa dioda D1
	TRISBbits.TRISB9 = 0;		//linia RB9 wyjciowa dioda D2

	//konfiguracja przerwania INT0
	INTCON2bits.INT0EP = 1;		//reakcja na zbocze opadajce
	IEC0bits.INT0IE = 1;		//wcz przerwanie INT0

	//konfiguracja przerwania moduu Timer2/3
	//1. ustawienie bitu T32
	T2CONbits.T32 = 1;
	//2. ustawienie preskalera
	T2CONbits.TCKPS1 = 0;		//preskaler 1:1
	T2CONbits.TCKPS0 = 0;
	//3. ustawienie TCS i TGATE (nie korzystamy)
	T2CONbits.TCS = 0;			//TCS = 0/1 taktowanie wewntrzne/zewntrzne
	T2CONbits.TGATE = 0;		//TGATE = 0/1 Gated Time Accumulation Mode wyczony/wczony
	//4. zaadowanie okresu (8 000 000 cykli = 1/2 sekundy przy taktowaniu 32 MHz)
	PR3 = 0x007A;
	PR2 = 0x1200;
	//5. wczenie przerwania moduu Timer2/3
	IEC0bits.T3IE = 1;
	IFS0bits.T3IF = 0;			//wyczy flag przerwania
	//6. wczenie moduu Timer2/3
	T2CONbits.TON = 1;

	for(;;)						//nieskoczona ptla
	{
		if(licznik>0)
		{
			LATBbits.LATB8 = 1;
			licznik--;
		}
		else LATBbits.LATB8 = 0;
		
		Czekaj_us(100000);		//czekaj 100 ms
	}
}

void __attribute__((interrupt,no_auto_psv)) _INT0Interrupt(void)
{
	licznik = 10;
	IFS0bits.INT0IF = 0;		//wyczy flag przerwania
}

void __attribute__((interrupt,no_auto_psv)) _T3Interrupt(void)
{
	LATBbits.LATB9 ^= 1;		//przecz stan diody D2
	IFS0bits.T3IF = 0;			//wyczy flag przerwania
}
