/**************************************************************
   Schemat podcze programowanego ukadu

                      +----v----+
                MCLR [| 1     40|] RB7 -> LED Dp
                     [| 2     39|] RB6 -> LED G
                     [| 3     38|] RB5 -> LED F
                     [| 4     37|] RB4 -> LED E
                     [| 5     36|] RB3 -> LED D
                     [| 6     35|] RB2 -> LED C
                     [| 7     34|] RB1 -> LED B
                     [| 8     33|] RB0 -> LED A
                     [| 9     32|] VDD
                     [|10     31|] VSS
                 VDD [|11     30|] 
                 VSS [|12     29|] 
     (20 MHz) / OSC1 [|13     28|] RD5 -> W6
              \ OSC2 [|14     27|] RD4 -> W5
(32,768 kHz) / T1OSO [|15     26|] 
             \ T1OSI [|16     25|] 
                     [|17     24|]
           S1 -> RC3 [|18     23|] RC4 <- S2
           W1 <- RD0 [|19     22|] RD3 -> W4
           W2 <- RD1 [|20     21|] RD2 -> W3
                      +---------+
                      PIC16F877A
***************************************************************/
//definiujemy szybko oscylatora dla funkcji __delay_
#define _XTAL_FREQ 20000000
#include <htc.h>

//oscylator 20 MHz (FOSC_HS)
//watchdog wyczony (WDTE_OFF)
//wyczone LVP (Low-Voltage ICSP Programming) (LVP_OFF)
__CONFIG(FOSC_HS & WDTE_OFF & LVP_OFF);

//zmienne globalne obsugi godziny
unsigned char godzina, godzina10, godzina1;
unsigned char minuta, minuta10, minuta1;
unsigned char sekunda, sekunda10, sekunda1;
//tablica cyfr dla wywietlacza LED
unsigned char cyfra[10] = {0b11000000, 0b11111001, //0, 1
                           0b10100100, 0b10110000, //2, 3
                           0b10011001, 0b10010010, //4, 5
                           0b10000010, 0b11111000, //6, 7
                           0b10000000, 0b10010000};//8, 9
//zmienna pomocnicza dla utworzenia czasu stabilizacji impulsu przycisku
unsigned char czy_juz_czas;

void main()
{
	TRISD = 0;				//linie portu D wyjciowe
	TRISB = 0;				//port B wyjciowy
	TRISCbits.TRISC3 = 1;	//linia RC3 z przyciskiem S1 wejciowa
	TRISCbits.TRISC4 = 1;	//linia RC4 z przyciskiem S2 wejciowa

	//wyzerowanie zmiennych
	godzina = 0;
	godzina1 = 0;
	godzina10 = 0;
	minuta = 0;
	minuta1 = 0;
	minuta10 = 0;
	sekunda = 0;
	sekunda1 = 0;
	sekunda10 = 0;
	czy_juz_czas = 0;

	//konfiguracja przerwania moduu Timer1
	TMR1H = 0x80;			//TMR1 = 32768
	TMR1L = 0x00;			//(podczony oscylator zegarkowy)
	//T1CONbits.T1CKPS1 = 0;//brak preskalera
	//T1CONbits.T1CKPS0 = 0;//brak preskalera
	PIE1bits.TMR1IE = 1;	//wcz przerwanie Timer1
	T1CONbits.T1OSCEN = 1;	//wcz oscylator dla Timer1
	T1CONbits.T1SYNC = 1;	//wycz synchronizacj zewn. oscylatora
	T1CONbits.TMR1CS = 1;	//zewntrzne rdo taktujce
	T1CONbits.TMR1ON = 1;	//wcz modu Timer1

	INTCONbits.PEIE = 1;	//wczenie przerwa urzdze peryferyjnych
	INTCONbits.GIE = 1;		//globalne wczenie przerwa

	for(;;)					//ptla nieskoczona
	{
		//wywietl godzin///////////
		PORTD = 0b00111110;			//wcz W1 (RD0 w stan logicznego 0)
									//W2, W3, W4, W5, W6 wyczone
		PORTB = cyfra[godzina10];	//wywietl cyfr 1
		__delay_ms(3);				//zaczekaj 5 ms

		PORTD = 0b00111101;			//wcz W2 (RD1 w stan logicznego 0)
									//W1, W3, W4, W5, W6 wyczone
		PORTB = cyfra[godzina1];	//wywietl cyfr 2
		__delay_ms(3);				//zaczekaj 5 ms

		//wywietl minut////////////
		PORTD = 0b00111011;			//wcz W3 (RD2 w stan logicznego 0)
									//W1, W2, W4, W5, W6 wyczone
		PORTB = cyfra[minuta10];	//wywietl cyfr 3
		__delay_ms(3);				//zaczekaj 5 ms

		PORTD = 0b00110111;			//wcz W4 (RD3 w stan logicznego 0)
									//W1, W2, W3, W5, W6 wyczone
		PORTB = cyfra[minuta1];		//wywietl cyfr 4
		__delay_ms(3);				//zaczekaj 5 ms

		//wywietl sekund///////////
		PORTD = 0b00101111;			//wcz W5 (RD4 w stan logicznego 0)
									//W1, W2, W3, W4, W6 wyczone
		PORTB = cyfra[sekunda10];	//wywietl cyfr 5
		__delay_ms(3);				//zaczekaj 5 ms

		PORTD = 0b00011111;			//wcz W6 (RD5 w stan logicznego 0)
									//W1, W2, W3, W4, W5 wyczone
		PORTB = cyfra[sekunda1];	//wywietl cyfr 6
		__delay_ms(3);				//zaczekaj 5 ms
	
		if(czy_juz_czas > 0) czy_juz_czas--;
		//obsuga przyciskw
		if(czy_juz_czas == 0)
		{
			//S1 - inkrementacja minuty
			if(PORTCbits.RC3 == 0)
			{
				minuta++;
				minuta1++;
				if(minuta1>9)
				{
					minuta1 = 0;
					minuta10++;
				}
				if(minuta > 59)
				{
					minuta = 0;
					minuta1 = 0;
					minuta10 = 0;
				}
				sekunda = 0;
				sekunda1 = 0;
				sekunda10 = 0;
			}
			//S2 - inkrementacja godziny
			if(PORTCbits.RC4 == 0)
			{
				godzina++;
				godzina1++;
				if(godzina1>9)
				{
					godzina1 = 0;
					godzina10++;
				}
				if(godzina > 23)
				{
					godzina = 0;
					godzina1 = 0;
					godzina10 = 0;
				}
			}
			czy_juz_czas = 20;
		}
	}
}

static void interrupt
knowania_przerwania(void)
{
	if(PIR1bits.TMR1IF == 1)	//przerwanie moduu Timer1 (wywoywane co 1 s)
	{
		TMR1H = 0x80;			//warto pocztkowa do TMR1
		//TMR1L = 0x00;			//TMR1L = 0, wic nie trzeba go nastawia
		//inkrementacja czasu
		sekunda++;
		//inkrementacja zmiennych wywietlania sekundy
		sekunda1++;
		if(sekunda1>9)
		{
			sekunda1 = 0;
			sekunda10++;
		}
		if(sekunda > 59)
		{
			sekunda = 0;
			sekunda1 = 0;
			sekunda10 = 0;
			minuta++;
			//inkrementacja zmiennych wywietlania minuty
			minuta1++;
			if(minuta1>9)
			{
				minuta1 = 0;
				minuta10++;
			}
			if(minuta > 59)
			{
				minuta = 0;
				minuta1 = 0;
				minuta10 = 0;
				godzina++;
				//inkrementacja zmiennych wywietlania godziny
				godzina1++;
				if(godzina1>9)
				{
					godzina1 = 0;
					godzina10++;
				}
				if(godzina > 23) 
				{
					godzina = 0;
					godzina1 = 0;
					godzina10 = 0;
				}
			}
		}
		PIR1bits.TMR1IF = 0;	//wyczy flag przerwania
	}
}

