/**************************************************************
        Schemat podcze programowanego ukadu
                       +----v----+
                 MCLR [| 1     28|] VDD
                      [| 2     27|] VSS
                      [| 3     26|] 
                      [| 4     25|] 
                      [| 5     24|] 
                      [| 6     23|] 
                      [| 7     22|] 
                  VSS [| 8     21|] 
                      [| 9     20|] VCAP/VDDCORE
                      [|10     19|] DISVREG
                      [|11     18|] 
                      [|12     17|] 
                  VDD [|13     16|] RB7 -> D1
                      [|14     15|] 
                       +---------+
                     PIC24FJ64GB002
***************************************************************/
#include <p24Fxxxx.h>

//ustawienia bitw konfiguracyjnych
//1. 
//FWDTEN_OFF - Watchdog wyczony
//JTAGEN_OFF - JTAG wyczony
_CONFIG1(FWDTEN_OFF & JTAGEN_OFF)
//2.
//FNOSC_FRC - ukad taktowany wewntrznym oscylatorem 8 MHz
//POSCMOD_NONE - Primary Oscillator wyczony
_CONFIG2(FNOSC_FRC & POSCMOD_NONE)

//funkcja tworzca opnienie
void Czekaj(unsigned long int ile)
{
	while(ile>0) ile--;
}

int main()
{
	TRISBbits.TRISB7 = 0;	//linia RB7 wyjciowa

	for(;;)					//nieskoczona ptla
	{
		LATBbits.LATB7 = 1;	//zawie diod
		Czekaj(0x16400);	//no c, czekamy (okoo 250 ms)
		LATBbits.LATB7 = 0;	//zga diod
		Czekaj(0x16400);	//znw czekamy (okoo 250 ms)
	}
}
