/**************************************************************
   Schemat podcze programowanego ukadu

                 +----v----+
           MCLR [| 1     40|] RB7 -> D4
                [| 2     39|] RB6 -> D3
                [| 3     38|] RB5 -> D2
                [| 4     37|] RB4 -> D1
                [| 5     36|] 
                [| 6     35|] 
                [| 7     34|] 
                [| 8     33|] 
                [| 9     32|] VDD
                [|10     31|] VSS
            VDD [|11     30|] 
            VSS [|12     29|] 
(20 MHz) / OSC1 [|13     28|]
         \ OSC2 [|14     27|]
      W1 -> RC0 [|15     26|] RC7 -> K4
      W2 -> RC1 [|16     25|] RC6 -> K3
      W3 -> RC2 [|17     24|] RC5 -> K2
      W4 -> RC3 [|18     23|] RC4 -> K1
                [|19     22|] 
                [|20     21|] 
                 +---------+
                 PIC16F877A
***************************************************************/

#include <htc.h>

//oscylator 20 MHz (FOSC_HS)
//watchdog wyczony (WDTE_OFF)
//wyczone LVP (Low-Voltage ICSP Programming) (LVP_OFF)
__CONFIG(FOSC_HS & WDTE_OFF & LVP_OFF);

void main()
{
	ADCON1 = 0x06;				//wyczenie linii analogowych 
                    			//(wszystkie linie cyfrowe)
	TRISC = 0x0F;				//linie RC0-RC3 wejciowe
								//linie RC4-RC7 wyjciowe
	TRISB = 0;					//linie portu B wyjciowe
	PORTB = 0;					//diody pocztkowo zgaszone	

	for(;;)						//ptla nieskoczona
	{
		//aktywacja przyciskw kolumy 1 (S1, S5, S9, S13)
		PORTCbits.RC4 = 0;		//na linii RC4 stan niski
		PORTCbits.RC5 = 1;		//na linii RC5 stan wysoki
		PORTCbits.RC6 = 1;		//na linii RC6 stan wysoki
		PORTCbits.RC7 = 1;		//na linii RC7 stan wysoki
		asm("nop");				//czas stabilizacji
		if(PORTCbits.RC0 == 0) PORTB = (1<<4);
		if(PORTCbits.RC1 == 0) PORTB = (5<<4);
		if(PORTCbits.RC2 == 0) PORTB = (9<<4);
		if(PORTCbits.RC3 == 0) PORTB = (13<<4);

		//aktywacja przyciskw kolumy 2 (S2, S6, S10, S14)
		PORTCbits.RC4 = 1;		//na linii RC4 stan wysoki
		PORTCbits.RC5 = 0;		//na linii RC5 stan niski
		PORTCbits.RC6 = 1;		//na linii RC6 stan wysoki
		PORTCbits.RC7 = 1;		//na linii RC7 stan wysoki
		asm("nop");				//czas stabilizacji
		if(PORTCbits.RC0 == 0) PORTB = (2<<4);
		if(PORTCbits.RC1 == 0) PORTB = (6<<4);
		if(PORTCbits.RC2 == 0) PORTB = (10<<4);
		if(PORTCbits.RC3 == 0) PORTB = (14<<4);

		//aktywacja przyciskw kolumy 3 (S3, S7, S11, S15)
		PORTCbits.RC4 = 1;		//na linii RC4 stan wysoki
		PORTCbits.RC5 = 1;		//na linii RC5 stan wysoki
		PORTCbits.RC6 = 0;		//na linii RC6 stan niski
		PORTCbits.RC7 = 1;		//na linii RC7 stan wysoki
		asm("nop");				//czas stabilizacji
		if(PORTCbits.RC0 == 0) PORTB = (3<<4);
		if(PORTCbits.RC1 == 0) PORTB = (7<<4);
		if(PORTCbits.RC2 == 0) PORTB = (11<<4);
		if(PORTCbits.RC3 == 0) PORTB = (15<<4);

		//aktywacja przyciskw kolumy 4 (S4, S8, S12, S16)
		PORTCbits.RC4 = 1;		//na linii RC4 stan wysoki
		PORTCbits.RC5 = 1;		//na linii RC5 stan wysoki
		PORTCbits.RC6 = 1;		//na linii RC6 stan wysoki
		PORTCbits.RC7 = 0;		//na linii RC7 stan niski
		asm("nop");				//czas stabilizacji
		if(PORTCbits.RC0 == 0) PORTB = (4<<4);
		if(PORTCbits.RC1 == 0) PORTB = (8<<4);
		if(PORTCbits.RC2 == 0) PORTB = (12<<4);
		if(PORTCbits.RC3 == 0) PORTB = 0;
	}
}
