/**************************************************************
   Schemat podcze programowanego ukadu

                 +----v----+
           MCLR [| 1     40|] RB7 <- S1
                [| 2     39|] 
                [| 3     38|] 
                [| 4     37|] 
                [| 5     36|] 
                [| 6     35|] 
      D1 <- RA5 [| 7     34|] 
                [| 8     33|] 
                [| 9     32|] VDD
                [|10     31|] VSS
            VDD [|11     30|] 
            VSS [|12     29|] 
(20 MHz) / OSC1 [|13     28|]
         \ OSC2 [|14     27|]
                [|15     26|] 
                [|16     25|] 
                [|17     24|]
                [|18     23|] 
                [|19     22|] 
                [|20     21|] 
                 +---------+
                 PIC16F877A
***************************************************************/

#include <htc.h>

//oscylator 20 MHz (FOSC_HS)
//watchdog wyczony (WDTE_OFF)
//wyczone LVP (Low-Voltage ICSP Programming) (LVP_OFF)
__CONFIG(FOSC_HS & WDTE_OFF & LVP_OFF);

void main()
{
	ADCON1 = 0x06;				//wyczenie linii analogowych 
                    			//(wszystkie linie cyfrowe)
	TRISAbits.TRISA5 = 0;		//linia RA5 wyjciowa
	TRISBbits.TRISB7 = 1;		//linia RB7 wejciowa	
	OPTION_REGbits.nRBPU = 0;	//wczenie wewntrznego pull-up dla linii portu B

	for(;;)						//ptla nieskoczona
	{
		if(PORTBbits.RB7 == 1)	//jeli przycisk nie jest zwarty
			PORTAbits.RA5 = 0;	//dioda ma by zgaszona
		else					//w przeciwnym przypadku
			PORTAbits.RA5 = 1;	//diod naley zawieci
	}
}
