/**************************************************************
        Schemat podcze programowanego ukadu
                       +----v----+
                 MCLR [| 1     28|] VDD
                      [| 2     27|] VSS
                      [| 3     26|] RB15 -> DB4        
       TC1047A -> AN2 [| 4     25|] RB14 -> DB5
                      [| 5     24|] RB13 -> DB6
                      [| 6     23|] 
                      [| 7     22|] RB11 -> DB7
                  VSS [| 8     21|] RB10 -> RS
       (8 MHz) / OSCI [| 9     20|] VCAP/VDDCORE
               \ OSCO [|10     19|] DISVREG
                      [|11     18|] RB9 -> EN
                      [|12     17|] 
                  VDD [|13     16|]  
                      [|14     15|] 
                       +---------+
                     PIC24FJ64GB002
***************************************************************/
#include <p24Fxxxx.h>
//definiujemy szybko oscylatora dla funkcji __delay_
#define FCY 16000000UL 
//biblioteka z funkcjami __delay_us i __delay_ms
#include <libpic30.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>


//ustawienia bitw konfiguracyjnych
//1. 
//FWDTEN_OFF - Watchdog wyczony
//JTAGEN_OFF - JTAG wyczony
_CONFIG1(FWDTEN_OFF & JTAGEN_OFF)
//2.
//FNOSC_PRIPLL - ukad taktowany zewntrznym oscylatorem z ptl PLL
//POSCMOD_XT - czstotliwo taktowania oscylatora 8 MHz
//PLLDIV_DIV2 - konieczno podzielenia przez 2 dla moduu USB PLL
_CONFIG2(FNOSC_PRIPLL & POSCMOD_XT & PLLDIV_DIV2)
//////////////////////////////////////
#define TRIS_RS_LCD   TRISBbits.TRISB10
#define TRIS_EN_LCD   TRISBbits.TRISB9
#define TRIS_DB4_LCD  TRISBbits.TRISB15
#define TRIS_DB5_LCD  TRISBbits.TRISB14
#define TRIS_DB6_LCD  TRISBbits.TRISB13
#define TRIS_DB7_LCD  TRISBbits.TRISB11

#define RS_LCD   LATBbits.LATB10
#define EN_LCD   LATBbits.LATB9
#define DB4_LCD  LATBbits.LATB15
#define DB5_LCD  LATBbits.LATB14
#define DB6_LCD  LATBbits.LATB13
#define DB7_LCD  LATBbits.LATB11

#include "lcd.h"
//////////////////////////////////////
char tablica[16];				//tablica danych
//tablice znakowe dla funkcji LCD
char napis1[] = "Temperatura:";	//12 znakw
char napis2[] = "     ";		//5 znakw  
char napis3[] = {' ', 223, 'C'};//3 znaki


int main()
{
	int wynikADC;
	float wynikF, wynikC, wynikU;

	/////////////////////////////////////////////////////
	AD1PCFGL = 0xFFFB;			//konfiguracja linii cyfrowych (AN2 - analogowe)

	/////////////////////////////////////////////////////
	//uruchomienie wywietlacza LCD//////////////////////
	WlaczLCD();					//inicjalizacja wywietlacza LCD
	WyswietlLCD(napis1, 12);	//wywietl napis "Temperatura:"

	/////////////////////////////////////////////////////
	//konfiguracja moduu ADC
	AD1CON1bits.SSRC = 7;		//czas prbkowania sterowany moduem, 
								//konwersja uruchamiana automatycznie
	AD1CHSbits.CH0SA = 2;		//wejcie analogowe AN2
	AD1CON3bits.SAMC = 0x1F;	//czas prbkowania = 31 TAD
	AD1CON3bits.ADCS = 2;		//czas TAD = 3 TCY
	AD1CON2bits.VCFG = 0;		//napicie odniesienia AVDD, AVSS
	AD1CON1bits.ADON = 1;		//wcz przetwornik

	/////////////////////////////////////////////////////
	//nieskoczona ptla
	for(;;)						
	{
		AD1CON1bits.SAMP = 1;	//wcz prbkowanie
		//czekaj na koniec konwersji 
		//(uruchomiona automatycznie po skoczeniu prbkowania)
		while (!AD1CON1bits.DONE);
		wynikADC = ADC1BUF0;	//odczytaj wynik
		wynikF = wynikADC;
		wynikF *= 330.0;
		wynikF /= 1023.0;
		wynikF -= 50.0;
		//rozdziel wynik na cz cakowit (wynikC) i uamkow (wynikU)
		wynikU = modff(wynikF, &wynikC);
		//wywietlimy 1 cyfr czci uamkowej
		wynikU *= 10.0;
		//wyodrbnij cz cakowit
		wynikU = floorf(wynikU);
		//czy fragment wywietlacza
		UstawKursorLCD(2, 1);	//wiersz 2 kolumna 1
		WyswietlLCD(napis2, 4);
		UstawKursorLCD(2, 1);	//wiersz 2 kolumna 1
		//wywietl cz cakowit
		wynikADC = (int)wynikC;
		itoa(tablica, wynikADC, 10);
		WyswietlLCD(tablica, strlen(tablica));
		//wywietl przecinek
		Wyslij_do_LCD(',');
		//wywietl cz uamkow (1 cyfra)
		wynikADC = (int)wynikU;
		utoa(tablica, wynikADC, 10);
		WyswietlLCD(tablica, 1);
		//wywietl napis "^C"
		WyswietlLCD(napis3, 3);		
		__delay_ms(500);
    }
}
