/**************************************************************
   Schemat podcze programowanego ukadu

                      +----v----+
                MCLR [| 1     40|] 
                     [| 2     39|] 
                     [| 3     38|] 
                     [| 4     37|] 
                     [| 5     36|] 
                     [| 6     35|] 
                     [| 7     34|] 
                     [| 8     33|] RB0 <- S1
                     [| 9     32|] VDD
                     [|10     31|] VSS
                 VDD [|11     30|] 
                 VSS [|12     29|] 
     (20 MHz) / OSC1 [|13     28|] 
              \ OSC2 [|14     27|] 
(32,768 kHz) / T1OSO [|15     26|] 
             \ T1OSI [|16     25|] 
                     [|17     24|]
                     [|18     23|] 
                     [|19     22|] 
                     [|20     21|] RD2 -> D1
                      +---------+
                      PIC16F877A
***************************************************************/
#include <htc.h>

//oscylator 20 MHz (FOSC_HS)
//watchdog wczony (WDTE_ON)
//wyczone LVP (Low-Voltage ICSP Programming) (LVP_OFF)
__CONFIG(FOSC_HS & WDTE_ON & LVP_OFF);


void main()
{
	TRISDbits.TRISD2 = 0;		//linia RD2 z diod D1 wyjciowa
	PORTDbits.RD2 = 0;			//urzdzenie wyczone (dioda zgaszona)
	TRISBbits.TRISB0 = 1;		//linia RB0 z przyciskiem S1 wejciowa
	OPTION_REGbits.nRBPU = 0;	//wczenie wewntrznego pull-up dla linii portu B
	//preskaler dla moduu watchdog = 128 (domylny) - reset po 2,3 s
	OPTION_REGbits.PS2 = 1;
	OPTION_REGbits.PS1 = 1;
	OPTION_REGbits.PS0 = 1;

	//konfiguracja przerwania moduu Timer1
	PIE1bits.TMR1IE = 1;		//wcz przerwanie Timer1
	T1CONbits.T1OSCEN = 1;		//wcz oscylator dla Timer1
	T1CONbits.T1SYNC = 1;		//wycz synchronizacj zewn. oscylatora
	T1CONbits.TMR1CS = 1;		//zewntrzne rdo taktujce
	T1CONbits.TMR1ON = 0;		//modu Timer1 na razie nieaktywny

	INTCONbits.PEIE = 1;		//wczenie przerwa urzdze peryferyjnych
	INTCONbits.GIE = 1;			//globalne wczenie przerwa

	for(;;)						//ptla nieskoczona
	{
		//czy wcinito przycisk
		if(PORTBbits.RB0 == 0)
		{
			TMR1H = 0x00;			//TMR1 = 0 
			TMR1L = 0x00;			//(podczony oscylator zegarkowy)
			T1CONbits.TMR1ON = 1;	//wcz modu Timer1
			PORTDbits.RD2 = 1;		//wcz urzdzenie (zawie diod)
									//czas wysyania impulsu = 2s
			//zaczekaj na wyczenie urzdzenia (zgaszenie diody)
			while(PORTDbits.RD2 == 1);
		}
		CLRWDT();					//zerowanie licznika moduu watchdog
	}
}

static void interrupt
knowania_przerwania(void)
{
	if(PIR1bits.TMR1IF == 1)	//przerwanie moduu Timer1 (wywoywane co 1 s)
	{
		T1CONbits.TMR1ON = 0;	//modu Timer1 na razie nieaktywny
		PORTDbits.RD2 = 0;		//wycz urzdzenie (zga diod)

		PIR1bits.TMR1IF = 0;	//wyczy flag przerwania
	}
}
