/**************************************************************
   Schemat podcze programowanego ukadu

                 +----v----+
           MCLR [| 1     40|] 
                [| 2     39|] 
                [| 3     38|] 
                [| 4     37|] 
                [| 5     36|] 
                [| 6     35|] 
                [| 7     34|] 
                [| 8     33|] RB0/INT <- S1
                [| 9     32|] VDD
                [|10     31|] VSS
            VDD [|11     30|] 
            VSS [|12     29|] 
(20 MHz) / OSC1 [|13     28|]
         \ OSC2 [|14     27|]
                [|15     26|] 
                [|16     25|] 
                [|17     24|]
                [|18     23|] 
      D1 <- RD0 [|19     22|] 
      D2 <- RD1 [|20     21|] 
                 +---------+
                 PIC16F877A
***************************************************************/

#include <htc.h>
//definiujemy szybko oscylatora dla funkcji __delay_
#define _XTAL_FREQ 20000000

//oscylator 20 MHz (FOSC_HS)
//watchdog wyczony (WDTE_OFF)
//wyczone LVP (Low-Voltage ICSP Programming) (LVP_OFF)
__CONFIG(FOSC_HS & WDTE_OFF & LVP_OFF);

//zmienna globalna (musi by widoczna w main i w funkcji obsugi przerwania)
unsigned char licznik;

void main()
{
	TRISDbits.TRISD0 = 0;		//linia RD0 wyjciowa
	TRISDbits.TRISD1 = 0;		//linia RD1 wyjciowa
	PORTDbits.RD0 = 0;			//dioda D1 nie wieci
	PORTDbits.RD1 = 0;			//dioda D2 nie wieci

	//konfiguracja przerwania RB0/INT
	OPTION_REGbits.INTEDG = 0;	//reakcja na zbocze opadajce
	INTCONbits.INTE = 1;		//wcz przerwanie RB0/INT

	INTCONbits.GIE = 1;			//globalne wczenie przerwa

	licznik = 0;
	for(;;)						//ptla nieskoczona
	{
		//wiecenie diody D2 jest uzalenione od stanu licznika
		if(licznik>0)
		{
			PORTDbits.RD1 = 1;
			licznik--;	
		}else PORTDbits.RD1 = 0;

		PORTDbits.RD0 ^= 1;		//przecz stan linii RD0
		__delay_ms(125);		//zaczekaj 1/8 sekundy
	}
}

static void interrupt
knowania_przerwania(void)
{
	if(INTCONbits.INTF) 
	{				
		licznik = 8;			//zawie diod D2 na czas 1 sekundy
		INTCONbits.INTF = 0;	//wyczy flag przerwania
	}
}

